/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A connection function test result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionFunctionTestResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionFunctionTestResult.Builder, ConnectionFunctionTestResult> {
    private static final SdkField<ConnectionFunctionSummary> CONNECTION_FUNCTION_SUMMARY_FIELD = SdkField
            .<ConnectionFunctionSummary> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionFunctionSummary")
            .getter(getter(ConnectionFunctionTestResult::connectionFunctionSummary))
            .setter(setter(Builder::connectionFunctionSummary))
            .constructor(ConnectionFunctionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionSummary")
                    .unmarshallLocationName("ConnectionFunctionSummary").build()).build();

    private static final SdkField<String> COMPUTE_UTILIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ComputeUtilization")
            .getter(getter(ConnectionFunctionTestResult::computeUtilization))
            .setter(setter(Builder::computeUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeUtilization")
                    .unmarshallLocationName("ComputeUtilization").build()).build();

    private static final SdkField<List<String>> CONNECTION_FUNCTION_EXECUTION_LOGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConnectionFunctionExecutionLogs")
            .getter(getter(ConnectionFunctionTestResult::connectionFunctionExecutionLogs))
            .setter(setter(Builder::connectionFunctionExecutionLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionExecutionLogs")
                    .unmarshallLocationName("ConnectionFunctionExecutionLogs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> CONNECTION_FUNCTION_ERROR_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionFunctionErrorMessage")
            .getter(getter(ConnectionFunctionTestResult::connectionFunctionErrorMessage))
            .setter(setter(Builder::connectionFunctionErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionErrorMessage")
                    .unmarshallLocationName("ConnectionFunctionErrorMessage").build()).build();

    private static final SdkField<String> CONNECTION_FUNCTION_OUTPUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionFunctionOutput")
            .getter(getter(ConnectionFunctionTestResult::connectionFunctionOutput))
            .setter(setter(Builder::connectionFunctionOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionOutput")
                    .unmarshallLocationName("ConnectionFunctionOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTION_FUNCTION_SUMMARY_FIELD, COMPUTE_UTILIZATION_FIELD, CONNECTION_FUNCTION_EXECUTION_LOGS_FIELD,
            CONNECTION_FUNCTION_ERROR_MESSAGE_FIELD, CONNECTION_FUNCTION_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConnectionFunctionSummary connectionFunctionSummary;

    private final String computeUtilization;

    private final List<String> connectionFunctionExecutionLogs;

    private final String connectionFunctionErrorMessage;

    private final String connectionFunctionOutput;

    private ConnectionFunctionTestResult(BuilderImpl builder) {
        this.connectionFunctionSummary = builder.connectionFunctionSummary;
        this.computeUtilization = builder.computeUtilization;
        this.connectionFunctionExecutionLogs = builder.connectionFunctionExecutionLogs;
        this.connectionFunctionErrorMessage = builder.connectionFunctionErrorMessage;
        this.connectionFunctionOutput = builder.connectionFunctionOutput;
    }

    /**
     * <p>
     * The connection function summary.
     * </p>
     * 
     * @return The connection function summary.
     */
    public final ConnectionFunctionSummary connectionFunctionSummary() {
        return connectionFunctionSummary;
    }

    /**
     * <p>
     * The connection function compute utilization.
     * </p>
     * 
     * @return The connection function compute utilization.
     */
    public final String computeUtilization() {
        return computeUtilization;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionFunctionExecutionLogs
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConnectionFunctionExecutionLogs() {
        return connectionFunctionExecutionLogs != null && !(connectionFunctionExecutionLogs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The connection function execution logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionFunctionExecutionLogs}
     * method.
     * </p>
     * 
     * @return The connection function execution logs.
     */
    public final List<String> connectionFunctionExecutionLogs() {
        return connectionFunctionExecutionLogs;
    }

    /**
     * <p>
     * The connection function error message.
     * </p>
     * 
     * @return The connection function error message.
     */
    public final String connectionFunctionErrorMessage() {
        return connectionFunctionErrorMessage;
    }

    /**
     * <p>
     * The connection function output.
     * </p>
     * 
     * @return The connection function output.
     */
    public final String connectionFunctionOutput() {
        return connectionFunctionOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(computeUtilization());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConnectionFunctionExecutionLogs() ? connectionFunctionExecutionLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionFunctionTestResult)) {
            return false;
        }
        ConnectionFunctionTestResult other = (ConnectionFunctionTestResult) obj;
        return Objects.equals(connectionFunctionSummary(), other.connectionFunctionSummary())
                && Objects.equals(computeUtilization(), other.computeUtilization())
                && hasConnectionFunctionExecutionLogs() == other.hasConnectionFunctionExecutionLogs()
                && Objects.equals(connectionFunctionExecutionLogs(), other.connectionFunctionExecutionLogs())
                && Objects.equals(connectionFunctionErrorMessage(), other.connectionFunctionErrorMessage())
                && Objects.equals(connectionFunctionOutput(), other.connectionFunctionOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConnectionFunctionTestResult")
                .add("ConnectionFunctionSummary", connectionFunctionSummary())
                .add("ComputeUtilization", computeUtilization())
                .add("ConnectionFunctionExecutionLogs",
                        connectionFunctionExecutionLogs() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectionFunctionErrorMessage",
                        connectionFunctionErrorMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectionFunctionOutput", connectionFunctionOutput() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionFunctionSummary":
            return Optional.ofNullable(clazz.cast(connectionFunctionSummary()));
        case "ComputeUtilization":
            return Optional.ofNullable(clazz.cast(computeUtilization()));
        case "ConnectionFunctionExecutionLogs":
            return Optional.ofNullable(clazz.cast(connectionFunctionExecutionLogs()));
        case "ConnectionFunctionErrorMessage":
            return Optional.ofNullable(clazz.cast(connectionFunctionErrorMessage()));
        case "ConnectionFunctionOutput":
            return Optional.ofNullable(clazz.cast(connectionFunctionOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionFunctionSummary", CONNECTION_FUNCTION_SUMMARY_FIELD);
        map.put("ComputeUtilization", COMPUTE_UTILIZATION_FIELD);
        map.put("ConnectionFunctionExecutionLogs", CONNECTION_FUNCTION_EXECUTION_LOGS_FIELD);
        map.put("ConnectionFunctionErrorMessage", CONNECTION_FUNCTION_ERROR_MESSAGE_FIELD);
        map.put("ConnectionFunctionOutput", CONNECTION_FUNCTION_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionFunctionTestResult, T> g) {
        return obj -> g.apply((ConnectionFunctionTestResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionFunctionTestResult> {
        /**
         * <p>
         * The connection function summary.
         * </p>
         * 
         * @param connectionFunctionSummary
         *        The connection function summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionSummary(ConnectionFunctionSummary connectionFunctionSummary);

        /**
         * <p>
         * The connection function summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionFunctionSummary.Builder}
         * avoiding the need to create one manually via {@link ConnectionFunctionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionFunctionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionFunctionSummary(ConnectionFunctionSummary)}.
         * 
         * @param connectionFunctionSummary
         *        a consumer that will call methods on {@link ConnectionFunctionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionFunctionSummary(ConnectionFunctionSummary)
         */
        default Builder connectionFunctionSummary(Consumer<ConnectionFunctionSummary.Builder> connectionFunctionSummary) {
            return connectionFunctionSummary(ConnectionFunctionSummary.builder().applyMutation(connectionFunctionSummary).build());
        }

        /**
         * <p>
         * The connection function compute utilization.
         * </p>
         * 
         * @param computeUtilization
         *        The connection function compute utilization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeUtilization(String computeUtilization);

        /**
         * <p>
         * The connection function execution logs.
         * </p>
         * 
         * @param connectionFunctionExecutionLogs
         *        The connection function execution logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionExecutionLogs(Collection<String> connectionFunctionExecutionLogs);

        /**
         * <p>
         * The connection function execution logs.
         * </p>
         * 
         * @param connectionFunctionExecutionLogs
         *        The connection function execution logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionExecutionLogs(String... connectionFunctionExecutionLogs);

        /**
         * <p>
         * The connection function error message.
         * </p>
         * 
         * @param connectionFunctionErrorMessage
         *        The connection function error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionErrorMessage(String connectionFunctionErrorMessage);

        /**
         * <p>
         * The connection function output.
         * </p>
         * 
         * @param connectionFunctionOutput
         *        The connection function output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionOutput(String connectionFunctionOutput);
    }

    static final class BuilderImpl implements Builder {
        private ConnectionFunctionSummary connectionFunctionSummary;

        private String computeUtilization;

        private List<String> connectionFunctionExecutionLogs = DefaultSdkAutoConstructList.getInstance();

        private String connectionFunctionErrorMessage;

        private String connectionFunctionOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionFunctionTestResult model) {
            connectionFunctionSummary(model.connectionFunctionSummary);
            computeUtilization(model.computeUtilization);
            connectionFunctionExecutionLogs(model.connectionFunctionExecutionLogs);
            connectionFunctionErrorMessage(model.connectionFunctionErrorMessage);
            connectionFunctionOutput(model.connectionFunctionOutput);
        }

        public final ConnectionFunctionSummary.Builder getConnectionFunctionSummary() {
            return connectionFunctionSummary != null ? connectionFunctionSummary.toBuilder() : null;
        }

        public final void setConnectionFunctionSummary(ConnectionFunctionSummary.BuilderImpl connectionFunctionSummary) {
            this.connectionFunctionSummary = connectionFunctionSummary != null ? connectionFunctionSummary.build() : null;
        }

        @Override
        public final Builder connectionFunctionSummary(ConnectionFunctionSummary connectionFunctionSummary) {
            this.connectionFunctionSummary = connectionFunctionSummary;
            return this;
        }

        public final String getComputeUtilization() {
            return computeUtilization;
        }

        public final void setComputeUtilization(String computeUtilization) {
            this.computeUtilization = computeUtilization;
        }

        @Override
        public final Builder computeUtilization(String computeUtilization) {
            this.computeUtilization = computeUtilization;
            return this;
        }

        public final Collection<String> getConnectionFunctionExecutionLogs() {
            if (connectionFunctionExecutionLogs instanceof SdkAutoConstructList) {
                return null;
            }
            return connectionFunctionExecutionLogs;
        }

        public final void setConnectionFunctionExecutionLogs(Collection<String> connectionFunctionExecutionLogs) {
            this.connectionFunctionExecutionLogs = FunctionExecutionLogListCopier.copy(connectionFunctionExecutionLogs);
        }

        @Override
        public final Builder connectionFunctionExecutionLogs(Collection<String> connectionFunctionExecutionLogs) {
            this.connectionFunctionExecutionLogs = FunctionExecutionLogListCopier.copy(connectionFunctionExecutionLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionFunctionExecutionLogs(String... connectionFunctionExecutionLogs) {
            connectionFunctionExecutionLogs(Arrays.asList(connectionFunctionExecutionLogs));
            return this;
        }

        public final String getConnectionFunctionErrorMessage() {
            return connectionFunctionErrorMessage;
        }

        public final void setConnectionFunctionErrorMessage(String connectionFunctionErrorMessage) {
            this.connectionFunctionErrorMessage = connectionFunctionErrorMessage;
        }

        @Override
        public final Builder connectionFunctionErrorMessage(String connectionFunctionErrorMessage) {
            this.connectionFunctionErrorMessage = connectionFunctionErrorMessage;
            return this;
        }

        public final String getConnectionFunctionOutput() {
            return connectionFunctionOutput;
        }

        public final void setConnectionFunctionOutput(String connectionFunctionOutput) {
            this.connectionFunctionOutput = connectionFunctionOutput;
        }

        @Override
        public final Builder connectionFunctionOutput(String connectionFunctionOutput) {
            this.connectionFunctionOutput = connectionFunctionOutput;
            return this;
        }

        @Override
        public ConnectionFunctionTestResult build() {
            return new ConnectionFunctionTestResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
