/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A connection function summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionFunctionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionFunctionSummary.Builder, ConnectionFunctionSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ConnectionFunctionSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ConnectionFunctionSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<FunctionConfig> CONNECTION_FUNCTION_CONFIG_FIELD = SdkField
            .<FunctionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionFunctionConfig")
            .getter(getter(ConnectionFunctionSummary::connectionFunctionConfig))
            .setter(setter(Builder::connectionFunctionConfig))
            .constructor(FunctionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionConfig")
                    .unmarshallLocationName("ConnectionFunctionConfig").build()).build();

    private static final SdkField<String> CONNECTION_FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionFunctionArn")
            .getter(getter(ConnectionFunctionSummary::connectionFunctionArn))
            .setter(setter(Builder::connectionFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionArn")
                    .unmarshallLocationName("ConnectionFunctionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ConnectionFunctionSummary::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Stage")
            .getter(getter(ConnectionFunctionSummary::stageAsString))
            .setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage")
                    .unmarshallLocationName("Stage").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(ConnectionFunctionSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(ConnectionFunctionSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            CONNECTION_FUNCTION_CONFIG_FIELD, CONNECTION_FUNCTION_ARN_FIELD, STATUS_FIELD, STAGE_FIELD, CREATED_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final FunctionConfig connectionFunctionConfig;

    private final String connectionFunctionArn;

    private final String status;

    private final String stage;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private ConnectionFunctionSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.connectionFunctionConfig = builder.connectionFunctionConfig;
        this.connectionFunctionArn = builder.connectionFunctionArn;
        this.status = builder.status;
        this.stage = builder.stage;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The connection function name.
     * </p>
     * 
     * @return The connection function name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The connection function ID.
     * </p>
     * 
     * @return The connection function ID.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the ConnectionFunctionConfig property for this object.
     * 
     * @return The value of the ConnectionFunctionConfig property for this object.
     */
    public final FunctionConfig connectionFunctionConfig() {
        return connectionFunctionConfig;
    }

    /**
     * <p>
     * The connection function Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The connection function Amazon Resource Name (ARN).
     */
    public final String connectionFunctionArn() {
        return connectionFunctionArn;
    }

    /**
     * <p>
     * The connection function status.
     * </p>
     * 
     * @return The connection function status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The connection function stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The connection function stage.
     * @see FunctionStage
     */
    public final FunctionStage stage() {
        return FunctionStage.fromValue(stage);
    }

    /**
     * <p>
     * The connection function stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The connection function stage.
     * @see FunctionStage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * The connection function created time.
     * </p>
     * 
     * @return The connection function created time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The connection function last modified time.
     * </p>
     * 
     * @return The connection function last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionFunctionSummary)) {
            return false;
        }
        ConnectionFunctionSummary other = (ConnectionFunctionSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(connectionFunctionConfig(), other.connectionFunctionConfig())
                && Objects.equals(connectionFunctionArn(), other.connectionFunctionArn())
                && Objects.equals(status(), other.status()) && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionFunctionSummary").add("Name", name()).add("Id", id())
                .add("ConnectionFunctionConfig", connectionFunctionConfig())
                .add("ConnectionFunctionArn", connectionFunctionArn()).add("Status", status()).add("Stage", stageAsString())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ConnectionFunctionConfig":
            return Optional.ofNullable(clazz.cast(connectionFunctionConfig()));
        case "ConnectionFunctionArn":
            return Optional.ofNullable(clazz.cast(connectionFunctionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ConnectionFunctionConfig", CONNECTION_FUNCTION_CONFIG_FIELD);
        map.put("ConnectionFunctionArn", CONNECTION_FUNCTION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionFunctionSummary, T> g) {
        return obj -> g.apply((ConnectionFunctionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionFunctionSummary> {
        /**
         * <p>
         * The connection function name.
         * </p>
         * 
         * @param name
         *        The connection function name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The connection function ID.
         * </p>
         * 
         * @param id
         *        The connection function ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ConnectionFunctionConfig property for this object.
         *
         * @param connectionFunctionConfig
         *        The new value for the ConnectionFunctionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig);

        /**
         * Sets the value of the ConnectionFunctionConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FunctionConfig.Builder} avoiding the need
         * to create one manually via {@link FunctionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionFunctionConfig(FunctionConfig)}.
         * 
         * @param connectionFunctionConfig
         *        a consumer that will call methods on {@link FunctionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionFunctionConfig(FunctionConfig)
         */
        default Builder connectionFunctionConfig(Consumer<FunctionConfig.Builder> connectionFunctionConfig) {
            return connectionFunctionConfig(FunctionConfig.builder().applyMutation(connectionFunctionConfig).build());
        }

        /**
         * <p>
         * The connection function Amazon Resource Name (ARN).
         * </p>
         * 
         * @param connectionFunctionArn
         *        The connection function Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionArn(String connectionFunctionArn);

        /**
         * <p>
         * The connection function status.
         * </p>
         * 
         * @param status
         *        The connection function status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The connection function stage.
         * </p>
         * 
         * @param stage
         *        The connection function stage.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * The connection function stage.
         * </p>
         * 
         * @param stage
         *        The connection function stage.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(FunctionStage stage);

        /**
         * <p>
         * The connection function created time.
         * </p>
         * 
         * @param createdTime
         *        The connection function created time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The connection function last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The connection function last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private FunctionConfig connectionFunctionConfig;

        private String connectionFunctionArn;

        private String status;

        private String stage;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionFunctionSummary model) {
            name(model.name);
            id(model.id);
            connectionFunctionConfig(model.connectionFunctionConfig);
            connectionFunctionArn(model.connectionFunctionArn);
            status(model.status);
            stage(model.stage);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final FunctionConfig.Builder getConnectionFunctionConfig() {
            return connectionFunctionConfig != null ? connectionFunctionConfig.toBuilder() : null;
        }

        public final void setConnectionFunctionConfig(FunctionConfig.BuilderImpl connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig != null ? connectionFunctionConfig.build() : null;
        }

        @Override
        public final Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        public final String getConnectionFunctionArn() {
            return connectionFunctionArn;
        }

        public final void setConnectionFunctionArn(String connectionFunctionArn) {
            this.connectionFunctionArn = connectionFunctionArn;
        }

        @Override
        public final Builder connectionFunctionArn(String connectionFunctionArn) {
            this.connectionFunctionArn = connectionFunctionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ConnectionFunctionSummary build() {
            return new ConnectionFunctionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
