/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CA certificates bundle source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaCertificatesBundleSource implements SdkPojo, Serializable,
        ToCopyableBuilder<CaCertificatesBundleSource.Builder, CaCertificatesBundleSource> {
    private static final SdkField<CaCertificatesBundleS3Location> CA_CERTIFICATES_BUNDLE_S3_LOCATION_FIELD = SdkField
            .<CaCertificatesBundleS3Location> builder(MarshallingType.SDK_POJO)
            .memberName("CaCertificatesBundleS3Location")
            .getter(getter(CaCertificatesBundleSource::caCertificatesBundleS3Location))
            .setter(setter(Builder::caCertificatesBundleS3Location))
            .constructor(CaCertificatesBundleS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Location")
                    .unmarshallLocationName("CaCertificatesBundleS3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CA_CERTIFICATES_BUNDLE_S3_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CaCertificatesBundleS3Location caCertificatesBundleS3Location;

    private final Type type;

    private CaCertificatesBundleSource(BuilderImpl builder) {
        this.caCertificatesBundleS3Location = builder.caCertificatesBundleS3Location;
        this.type = builder.type;
    }

    /**
     * <p>
     * The CA certificates bundle location in Amazon S3.
     * </p>
     * 
     * @return The CA certificates bundle location in Amazon S3.
     */
    public final CaCertificatesBundleS3Location caCertificatesBundleS3Location() {
        return caCertificatesBundleS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaCertificatesBundleSource)) {
            return false;
        }
        CaCertificatesBundleSource other = (CaCertificatesBundleSource) obj;
        return Objects.equals(caCertificatesBundleS3Location(), other.caCertificatesBundleS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaCertificatesBundleSource")
                .add("CaCertificatesBundleS3Location", caCertificatesBundleS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaCertificatesBundleS3Location":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3Location()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #caCertificatesBundleS3Location()} initialized to the given value.
     *
     * <p>
     * The CA certificates bundle location in Amazon S3.
     * </p>
     * 
     * @param caCertificatesBundleS3Location
     *        The CA certificates bundle location in Amazon S3.
     */
    public static CaCertificatesBundleSource fromCaCertificatesBundleS3Location(
            CaCertificatesBundleS3Location caCertificatesBundleS3Location) {
        return builder().caCertificatesBundleS3Location(caCertificatesBundleS3Location).build();
    }

    /**
     * Create an instance of this class with {@link #caCertificatesBundleS3Location()} initialized to the given value.
     *
     * <p>
     * The CA certificates bundle location in Amazon S3.
     * </p>
     * 
     * @param caCertificatesBundleS3Location
     *        The CA certificates bundle location in Amazon S3.
     */
    public static CaCertificatesBundleSource fromCaCertificatesBundleS3Location(
            Consumer<CaCertificatesBundleS3Location.Builder> caCertificatesBundleS3Location) {
        CaCertificatesBundleS3Location.Builder builder = CaCertificatesBundleS3Location.builder();
        caCertificatesBundleS3Location.accept(builder);
        return fromCaCertificatesBundleS3Location(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CaCertificatesBundleS3Location", CA_CERTIFICATES_BUNDLE_S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaCertificatesBundleSource, T> g) {
        return obj -> g.apply((CaCertificatesBundleSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaCertificatesBundleSource> {
        /**
         * <p>
         * The CA certificates bundle location in Amazon S3.
         * </p>
         * 
         * @param caCertificatesBundleS3Location
         *        The CA certificates bundle location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3Location(CaCertificatesBundleS3Location caCertificatesBundleS3Location);

        /**
         * <p>
         * The CA certificates bundle location in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaCertificatesBundleS3Location.Builder}
         * avoiding the need to create one manually via {@link CaCertificatesBundleS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaCertificatesBundleS3Location.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #caCertificatesBundleS3Location(CaCertificatesBundleS3Location)}.
         * 
         * @param caCertificatesBundleS3Location
         *        a consumer that will call methods on {@link CaCertificatesBundleS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caCertificatesBundleS3Location(CaCertificatesBundleS3Location)
         */
        default Builder caCertificatesBundleS3Location(
                Consumer<CaCertificatesBundleS3Location.Builder> caCertificatesBundleS3Location) {
            return caCertificatesBundleS3Location(CaCertificatesBundleS3Location.builder()
                    .applyMutation(caCertificatesBundleS3Location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CaCertificatesBundleS3Location caCertificatesBundleS3Location;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CaCertificatesBundleSource model) {
            caCertificatesBundleS3Location(model.caCertificatesBundleS3Location);
        }

        public final CaCertificatesBundleS3Location.Builder getCaCertificatesBundleS3Location() {
            return caCertificatesBundleS3Location != null ? caCertificatesBundleS3Location.toBuilder() : null;
        }

        public final void setCaCertificatesBundleS3Location(
                CaCertificatesBundleS3Location.BuilderImpl caCertificatesBundleS3Location) {
            Object oldValue = this.caCertificatesBundleS3Location;
            this.caCertificatesBundleS3Location = caCertificatesBundleS3Location != null ? caCertificatesBundleS3Location.build()
                    : null;
            handleUnionValueChange(Type.CA_CERTIFICATES_BUNDLE_S3_LOCATION, oldValue, this.caCertificatesBundleS3Location);
        }

        @Override
        public final Builder caCertificatesBundleS3Location(CaCertificatesBundleS3Location caCertificatesBundleS3Location) {
            Object oldValue = this.caCertificatesBundleS3Location;
            this.caCertificatesBundleS3Location = caCertificatesBundleS3Location;
            handleUnionValueChange(Type.CA_CERTIFICATES_BUNDLE_S3_LOCATION, oldValue, this.caCertificatesBundleS3Location);
            return this;
        }

        @Override
        public CaCertificatesBundleSource build() {
            return new CaCertificatesBundleSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CaCertificatesBundleSource#type()
     */
    public enum Type {
        CA_CERTIFICATES_BUNDLE_S3_LOCATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
