/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An abbreviated version of the <a>AnycastIpList</a> structure. Omits the allocated static IP addresses
 * (<a>AnycastIpList$AnycastIps</a>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnycastIpListSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AnycastIpListSummary.Builder, AnycastIpListSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(AnycastIpListSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(AnycastIpListSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(AnycastIpListSummary::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(AnycastIpListSummary::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<Integer> IP_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IpCount")
            .getter(getter(AnycastIpListSummary::ipCount))
            .setter(setter(Builder::ipCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpCount")
                    .unmarshallLocationName("IpCount").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(AnycastIpListSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType")
            .getter(getter(AnycastIpListSummary::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType")
                    .unmarshallLocationName("IpAddressType").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(AnycastIpListSummary::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag")
                    .unmarshallLocationName("ETag").build()).build();

    private static final SdkField<IpamConfig> IPAM_CONFIG_FIELD = SdkField
            .<IpamConfig> builder(MarshallingType.SDK_POJO)
            .memberName("IpamConfig")
            .getter(getter(AnycastIpListSummary::ipamConfig))
            .setter(setter(Builder::ipamConfig))
            .constructor(IpamConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamConfig")
                    .unmarshallLocationName("IpamConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, ARN_FIELD, IP_COUNT_FIELD, LAST_MODIFIED_TIME_FIELD, IP_ADDRESS_TYPE_FIELD, E_TAG_FIELD,
            IPAM_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String status;

    private final String arn;

    private final Integer ipCount;

    private final Instant lastModifiedTime;

    private final String ipAddressType;

    private final String eTag;

    private final IpamConfig ipamConfig;

    private AnycastIpListSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.arn = builder.arn;
        this.ipCount = builder.ipCount;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.ipAddressType = builder.ipAddressType;
        this.eTag = builder.eTag;
        this.ipamConfig = builder.ipamConfig;
    }

    /**
     * <p>
     * The ID of the Anycast static IP list.
     * </p>
     * 
     * @return The ID of the Anycast static IP list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the Anycast static IP list.
     * </p>
     * 
     * @return The name of the Anycast static IP list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The deployment status of the Anycast static IP list. Valid values: Deployed, Deploying, or Failed.
     * </p>
     * 
     * @return The deployment status of the Anycast static IP list. Valid values: Deployed, Deploying, or Failed.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Anycast static IP list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Anycast static IP list.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of IP addresses in the Anycast static IP list.
     * </p>
     * 
     * @return The number of IP addresses in the Anycast static IP list.
     */
    public final Integer ipCount() {
        return ipCount;
    }

    /**
     * <p>
     * The last time the Anycast static IP list was modified.
     * </p>
     * 
     * @return The last time the Anycast static IP list was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The IP address type for the Anycast static IP list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the Anycast static IP list.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the Anycast static IP list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the Anycast static IP list.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The current version (ETag value) of the Anycast static IP list.
     * </p>
     * 
     * @return The current version (ETag value) of the Anycast static IP list.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The IPAM configuration for the Anycast static IP list, that contains the quantity and list of IPAM CIDR
     * configurations.
     * </p>
     * 
     * @return The IPAM configuration for the Anycast static IP list, that contains the quantity and list of IPAM CIDR
     *         configurations.
     */
    public final IpamConfig ipamConfig() {
        return ipamConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ipCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(ipamConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnycastIpListSummary)) {
            return false;
        }
        AnycastIpListSummary other = (AnycastIpListSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status()) && Objects.equals(arn(), other.arn())
                && Objects.equals(ipCount(), other.ipCount()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(ipamConfig(), other.ipamConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnycastIpListSummary").add("Id", id()).add("Name", name()).add("Status", status())
                .add("Arn", arn()).add("IpCount", ipCount()).add("LastModifiedTime", lastModifiedTime())
                .add("IpAddressType", ipAddressTypeAsString()).add("ETag", eTag()).add("IpamConfig", ipamConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "IpCount":
            return Optional.ofNullable(clazz.cast(ipCount()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "IpamConfig":
            return Optional.ofNullable(clazz.cast(ipamConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("IpCount", IP_COUNT_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("IpamConfig", IPAM_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnycastIpListSummary, T> g) {
        return obj -> g.apply((AnycastIpListSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnycastIpListSummary> {
        /**
         * <p>
         * The ID of the Anycast static IP list.
         * </p>
         * 
         * @param id
         *        The ID of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the Anycast static IP list.
         * </p>
         * 
         * @param name
         *        The name of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The deployment status of the Anycast static IP list. Valid values: Deployed, Deploying, or Failed.
         * </p>
         * 
         * @param status
         *        The deployment status of the Anycast static IP list. Valid values: Deployed, Deploying, or Failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Anycast static IP list.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of IP addresses in the Anycast static IP list.
         * </p>
         * 
         * @param ipCount
         *        The number of IP addresses in the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipCount(Integer ipCount);

        /**
         * <p>
         * The last time the Anycast static IP list was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the Anycast static IP list was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The IP address type for the Anycast static IP list.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the Anycast static IP list.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the Anycast static IP list.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the Anycast static IP list.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The current version (ETag value) of the Anycast static IP list.
         * </p>
         * 
         * @param eTag
         *        The current version (ETag value) of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The IPAM configuration for the Anycast static IP list, that contains the quantity and list of IPAM CIDR
         * configurations.
         * </p>
         * 
         * @param ipamConfig
         *        The IPAM configuration for the Anycast static IP list, that contains the quantity and list of IPAM
         *        CIDR configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamConfig(IpamConfig ipamConfig);

        /**
         * <p>
         * The IPAM configuration for the Anycast static IP list, that contains the quantity and list of IPAM CIDR
         * configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamConfig.Builder} avoiding the need to
         * create one manually via {@link IpamConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #ipamConfig(IpamConfig)}.
         * 
         * @param ipamConfig
         *        a consumer that will call methods on {@link IpamConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamConfig(IpamConfig)
         */
        default Builder ipamConfig(Consumer<IpamConfig.Builder> ipamConfig) {
            return ipamConfig(IpamConfig.builder().applyMutation(ipamConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String status;

        private String arn;

        private Integer ipCount;

        private Instant lastModifiedTime;

        private String ipAddressType;

        private String eTag;

        private IpamConfig ipamConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AnycastIpListSummary model) {
            id(model.id);
            name(model.name);
            status(model.status);
            arn(model.arn);
            ipCount(model.ipCount);
            lastModifiedTime(model.lastModifiedTime);
            ipAddressType(model.ipAddressType);
            eTag(model.eTag);
            ipamConfig(model.ipamConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getIpCount() {
            return ipCount;
        }

        public final void setIpCount(Integer ipCount) {
            this.ipCount = ipCount;
        }

        @Override
        public final Builder ipCount(Integer ipCount) {
            this.ipCount = ipCount;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final IpamConfig.Builder getIpamConfig() {
            return ipamConfig != null ? ipamConfig.toBuilder() : null;
        }

        public final void setIpamConfig(IpamConfig.BuilderImpl ipamConfig) {
            this.ipamConfig = ipamConfig != null ? ipamConfig.build() : null;
        }

        @Override
        public final Builder ipamConfig(IpamConfig ipamConfig) {
            this.ipamConfig = ipamConfig;
            return this;
        }

        @Override
        public AnycastIpListSummary build() {
            return new AnycastIpListSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
