/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.IpAddressType;
import software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig;
import software.amazon.awssdk.services.cloudfront.model.IpamCidrConfigListCopier;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnycastIpListRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateAnycastIpListRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAnycastIpListRequest.getter(CreateAnycastIpListRequest::name)).setter(CreateAnycastIpListRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<Integer> IP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IpCount").getter(CreateAnycastIpListRequest.getter(CreateAnycastIpListRequest::ipCount)).setter(CreateAnycastIpListRequest.setter(Builder::ipCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpCount").unmarshallLocationName("IpCount").build()}).build();
    private static final SdkField<Tags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(CreateAnycastIpListRequest.getter(CreateAnycastIpListRequest::tags)).setter(CreateAnycastIpListRequest.setter(Builder::tags)).constructor(Tags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(CreateAnycastIpListRequest.getter(CreateAnycastIpListRequest::ipAddressTypeAsString)).setter(CreateAnycastIpListRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").unmarshallLocationName("IpAddressType").build()}).build();
    private static final SdkField<List<IpamCidrConfig>> IPAM_CIDR_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamCidrConfigs").getter(CreateAnycastIpListRequest.getter(CreateAnycastIpListRequest::ipamCidrConfigs)).setter(CreateAnycastIpListRequest.setter(Builder::ipamCidrConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamCidrConfigs").unmarshallLocationName("IpamCidrConfigs").build(), ListTrait.builder().memberLocationName("IpamCidrConfig").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamCidrConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamCidrConfig").unmarshallLocationName("IpamCidrConfig").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IP_COUNT_FIELD, TAGS_FIELD, IP_ADDRESS_TYPE_FIELD, IPAM_CIDR_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAnycastIpListRequest.memberNameToFieldInitializer();
    private final String name;
    private final Integer ipCount;
    private final Tags tags;
    private final String ipAddressType;
    private final List<IpamCidrConfig> ipamCidrConfigs;

    private CreateAnycastIpListRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ipCount = builder.ipCount;
        this.tags = builder.tags;
        this.ipAddressType = builder.ipAddressType;
        this.ipamCidrConfigs = builder.ipamCidrConfigs;
    }

    public final String name() {
        return this.name;
    }

    public final Integer ipCount() {
        return this.ipCount;
    }

    public final Tags tags() {
        return this.tags;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final boolean hasIpamCidrConfigs() {
        return this.ipamCidrConfigs != null && !(this.ipamCidrConfigs instanceof SdkAutoConstructList);
    }

    public final List<IpamCidrConfig> ipamCidrConfigs() {
        return this.ipamCidrConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamCidrConfigs() ? this.ipamCidrConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnycastIpListRequest)) {
            return false;
        }
        CreateAnycastIpListRequest other = (CreateAnycastIpListRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ipCount(), other.ipCount()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && this.hasIpamCidrConfigs() == other.hasIpamCidrConfigs() && Objects.equals(this.ipamCidrConfigs(), other.ipamCidrConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnycastIpListRequest").add("Name", (Object)this.name()).add("IpCount", (Object)this.ipCount()).add("Tags", (Object)this.tags()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("IpamCidrConfigs", this.hasIpamCidrConfigs() ? this.ipamCidrConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IpCount": {
                return Optional.ofNullable(clazz.cast(this.ipCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "IpamCidrConfigs": {
                return Optional.ofNullable(clazz.cast(this.ipamCidrConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("IpCount", IP_COUNT_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("IpamCidrConfigs", IPAM_CIDR_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnycastIpListRequest, T> g) {
        return obj -> g.apply((CreateAnycastIpListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String name;
        private Integer ipCount;
        private Tags tags;
        private String ipAddressType;
        private List<IpamCidrConfig> ipamCidrConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnycastIpListRequest model) {
            super(model);
            this.name(model.name);
            this.ipCount(model.ipCount);
            this.tags(model.tags);
            this.ipAddressType(model.ipAddressType);
            this.ipamCidrConfigs(model.ipamCidrConfigs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getIpCount() {
            return this.ipCount;
        }

        public final void setIpCount(Integer ipCount) {
            this.ipCount = ipCount;
        }

        @Override
        public final Builder ipCount(Integer ipCount) {
            this.ipCount = ipCount;
            return this;
        }

        public final Tags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final List<IpamCidrConfig.Builder> getIpamCidrConfigs() {
            List<IpamCidrConfig.Builder> result = IpamCidrConfigListCopier.copyToBuilder(this.ipamCidrConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamCidrConfigs(Collection<IpamCidrConfig.BuilderImpl> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copyFromBuilder(ipamCidrConfigs);
        }

        @Override
        public final Builder ipamCidrConfigs(Collection<IpamCidrConfig> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copy(ipamCidrConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(IpamCidrConfig ... ipamCidrConfigs) {
            this.ipamCidrConfigs(Arrays.asList(ipamCidrConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder> ... ipamCidrConfigs) {
            this.ipamCidrConfigs(Stream.of(ipamCidrConfigs).map(c -> (IpamCidrConfig)((IpamCidrConfig.Builder)IpamCidrConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnycastIpListRequest build() {
            return new CreateAnycastIpListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnycastIpListRequest> {
        public Builder name(String var1);

        public Builder ipCount(Integer var1);

        public Builder tags(Tags var1);

        default public Builder tags(Consumer<Tags.Builder> tags) {
            return this.tags((Tags)((Tags.Builder)Tags.builder().applyMutation(tags)).build());
        }

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder ipamCidrConfigs(Collection<IpamCidrConfig> var1);

        public Builder ipamCidrConfigs(IpamCidrConfig ... var1);

        public Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

