/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationResponse;

public class ListDistributionTenantsByCustomizationPublisher
implements SdkPublisher<ListDistributionTenantsByCustomizationResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionTenantsByCustomizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionTenantsByCustomizationPublisher(CloudFrontAsyncClient client, ListDistributionTenantsByCustomizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionTenantsByCustomizationPublisher(CloudFrontAsyncClient client, ListDistributionTenantsByCustomizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionTenantsByCustomizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionTenantsByCustomizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionTenantSummary> distributionTenantList() {
        Function<ListDistributionTenantsByCustomizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionTenantList() != null) {
                return response.distributionTenantList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDistributionTenantsByCustomizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDistributionTenantsByCustomizationResponseFetcher
    implements AsyncPageFetcher<ListDistributionTenantsByCustomizationResponse> {
        private ListDistributionTenantsByCustomizationResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionTenantsByCustomizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListDistributionTenantsByCustomizationResponse> nextPage(ListDistributionTenantsByCustomizationResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionTenantsByCustomizationPublisher.this.client.listDistributionTenantsByCustomization(ListDistributionTenantsByCustomizationPublisher.this.firstRequest);
            }
            return ListDistributionTenantsByCustomizationPublisher.this.client.listDistributionTenantsByCustomization((ListDistributionTenantsByCustomizationRequest)((Object)ListDistributionTenantsByCustomizationPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

