/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary;

public class ListOriginAccessControlsIterable
implements SdkIterable<ListOriginAccessControlsResponse> {
    private final CloudFrontClient client;
    private final ListOriginAccessControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOriginAccessControlsIterable(CloudFrontClient client, ListOriginAccessControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOriginAccessControlsResponseFetcher();
    }

    public Iterator<ListOriginAccessControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OriginAccessControlSummary> items() {
        Function<ListOriginAccessControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.originAccessControlList() != null && response.originAccessControlList().items() != null) {
                return response.originAccessControlList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOriginAccessControlsResponseFetcher
    implements SyncPageFetcher<ListOriginAccessControlsResponse> {
        private ListOriginAccessControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginAccessControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.originAccessControlList().nextMarker());
        }

        public ListOriginAccessControlsResponse nextPage(ListOriginAccessControlsResponse previousPage) {
            if (previousPage == null) {
                return ListOriginAccessControlsIterable.this.client.listOriginAccessControls(ListOriginAccessControlsIterable.this.firstRequest);
            }
            return ListOriginAccessControlsIterable.this.client.listOriginAccessControls((ListOriginAccessControlsRequest)((Object)ListOriginAccessControlsIterable.this.firstRequest.toBuilder().marker(previousPage.originAccessControlList().nextMarker()).build()));
        }
    }
}

