/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfront.endpoints.CloudFrontEndpointParams;
import software.amazon.awssdk.services.cloudfront.endpoints.CloudFrontEndpointProvider;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCloudFrontEndpointProvider
implements CloudFrontEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CloudFrontEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CloudFrontEndpointParams params, String region) {
        RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultCloudFrontEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(CloudFrontEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultCloudFrontEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(CloudFrontEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(CloudFrontEndpointParams params, String region) {
        RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(CloudFrontEndpointParams params, String region) {
        if (region != null) {
            return DefaultCloudFrontEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CloudFrontEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
            }
            if ("aws".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront-fips.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront.cn-northwest-1.amazonaws.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("cn-northwest-1").build())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront-fips.cn-northwest-1.amazonaws.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("cn-northwest-1").build())).build());
            }
            RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule13(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCloudFrontEndpointProvider.endpointRule17(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCloudFrontEndpointProvider.endpointRule21(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(CloudFrontEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule14(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(CloudFrontEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront-fips." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(CloudFrontEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule18(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(CloudFrontEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront-fips." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(CloudFrontEndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCloudFrontEndpointProvider.endpointRule22(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(CloudFrontEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cloudfront." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

