/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.services.cloudfront.model.VpcOriginEndpointConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcOriginRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateVpcOriginRequest> {
    private static final SdkField<VpcOriginEndpointConfig> VPC_ORIGIN_ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOriginEndpointConfig").getter(CreateVpcOriginRequest.getter(CreateVpcOriginRequest::vpcOriginEndpointConfig)).setter(CreateVpcOriginRequest.setter(Builder::vpcOriginEndpointConfig)).constructor(VpcOriginEndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginEndpointConfig").unmarshallLocationName("VpcOriginEndpointConfig").build()}).build();
    private static final SdkField<Tags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(CreateVpcOriginRequest.getter(CreateVpcOriginRequest::tags)).setter(CreateVpcOriginRequest.setter(Builder::tags)).constructor(Tags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ORIGIN_ENDPOINT_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVpcOriginRequest.memberNameToFieldInitializer();
    private final VpcOriginEndpointConfig vpcOriginEndpointConfig;
    private final Tags tags;

    private CreateVpcOriginRequest(BuilderImpl builder) {
        super(builder);
        this.vpcOriginEndpointConfig = builder.vpcOriginEndpointConfig;
        this.tags = builder.tags;
    }

    public final VpcOriginEndpointConfig vpcOriginEndpointConfig() {
        return this.vpcOriginEndpointConfig;
    }

    public final Tags tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOriginEndpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcOriginRequest)) {
            return false;
        }
        CreateVpcOriginRequest other = (CreateVpcOriginRequest)((Object)obj);
        return Objects.equals(this.vpcOriginEndpointConfig(), other.vpcOriginEndpointConfig()) && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcOriginRequest").add("VpcOriginEndpointConfig", (Object)this.vpcOriginEndpointConfig()).add("Tags", (Object)this.tags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcOriginEndpointConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcOriginEndpointConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcOriginEndpointConfig", VPC_ORIGIN_ENDPOINT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcOriginRequest, T> g) {
        return obj -> g.apply((CreateVpcOriginRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private VpcOriginEndpointConfig vpcOriginEndpointConfig;
        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcOriginRequest model) {
            super(model);
            this.vpcOriginEndpointConfig(model.vpcOriginEndpointConfig);
            this.tags(model.tags);
        }

        public final VpcOriginEndpointConfig.Builder getVpcOriginEndpointConfig() {
            return this.vpcOriginEndpointConfig != null ? this.vpcOriginEndpointConfig.toBuilder() : null;
        }

        public final void setVpcOriginEndpointConfig(VpcOriginEndpointConfig.BuilderImpl vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.build() : null;
        }

        @Override
        public final Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig;
            return this;
        }

        public final Tags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcOriginRequest build() {
            return new CreateVpcOriginRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcOriginRequest> {
        public Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig var1);

        default public Builder vpcOriginEndpointConfig(Consumer<VpcOriginEndpointConfig.Builder> vpcOriginEndpointConfig) {
            return this.vpcOriginEndpointConfig((VpcOriginEndpointConfig)((VpcOriginEndpointConfig.Builder)VpcOriginEndpointConfig.builder().applyMutation(vpcOriginEndpointConfig)).build());
        }

        public Builder tags(Tags var1);

        default public Builder tags(Consumer<Tags.Builder> tags) {
            return this.tags((Tags)((Tags.Builder)Tags.builder().applyMutation(tags)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

