/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a public key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicKeySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicKeySummary.Builder, PublicKeySummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(PublicKeySummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(PublicKeySummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(PublicKeySummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<String> ENCODED_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncodedKey")
            .getter(getter(PublicKeySummary::encodedKey))
            .setter(setter(Builder::encodedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedKey")
                    .unmarshallLocationName("EncodedKey").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(PublicKeySummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CREATED_TIME_FIELD, ENCODED_KEY_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final Instant createdTime;

    private final String encodedKey;

    private final String comment;

    private PublicKeySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.encodedKey = builder.encodedKey;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The identifier of the public key.
     * </p>
     * 
     * @return The identifier of the public key.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A name to help identify the public key.
     * </p>
     * 
     * @return A name to help identify the public key.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date and time when the public key was uploaded.
     * </p>
     * 
     * @return The date and time when the public key was uploaded.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The public key.
     * </p>
     * 
     * @return The public key.
     */
    public final String encodedKey() {
        return encodedKey;
    }

    /**
     * <p>
     * A comment to describe the public key. The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return A comment to describe the public key. The comment cannot be longer than 128 characters.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(encodedKey());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKeySummary)) {
            return false;
        }
        PublicKeySummary other = (PublicKeySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(encodedKey(), other.encodedKey())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicKeySummary").add("Id", id()).add("Name", name()).add("CreatedTime", createdTime())
                .add("EncodedKey", encodedKey()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EncodedKey":
            return Optional.ofNullable(clazz.cast(encodedKey()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EncodedKey", ENCODED_KEY_FIELD);
        map.put("Comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublicKeySummary, T> g) {
        return obj -> g.apply((PublicKeySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicKeySummary> {
        /**
         * <p>
         * The identifier of the public key.
         * </p>
         * 
         * @param id
         *        The identifier of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A name to help identify the public key.
         * </p>
         * 
         * @param name
         *        A name to help identify the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time when the public key was uploaded.
         * </p>
         * 
         * @param createdTime
         *        The date and time when the public key was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The public key.
         * </p>
         * 
         * @param encodedKey
         *        The public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedKey(String encodedKey);

        /**
         * <p>
         * A comment to describe the public key. The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        A comment to describe the public key. The comment cannot be longer than 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private Instant createdTime;

        private String encodedKey;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKeySummary model) {
            id(model.id);
            name(model.name);
            createdTime(model.createdTime);
            encodedKey(model.encodedKey);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEncodedKey() {
            return encodedKey;
        }

        public final void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }

        @Override
        public final Builder encodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public PublicKeySummary build() {
            return new PublicKeySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
