/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary;
import software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectionGroupsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListConnectionGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListConnectionGroupsResponse.getter(ListConnectionGroupsResponse::nextMarker)).setter(ListConnectionGroupsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<List<ConnectionGroupSummary>> CONNECTION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionGroups").getter(ListConnectionGroupsResponse.getter(ListConnectionGroupsResponse::connectionGroups)).setter(ListConnectionGroupsResponse.setter(Builder::connectionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroups").unmarshallLocationName("ConnectionGroups").build(), ListTrait.builder().memberLocationName("ConnectionGroupSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroupSummary").unmarshallLocationName("ConnectionGroupSummary").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, CONNECTION_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectionGroupsResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<ConnectionGroupSummary> connectionGroups;

    private ListConnectionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.connectionGroups = builder.connectionGroups;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasConnectionGroups() {
        return this.connectionGroups != null && !(this.connectionGroups instanceof SdkAutoConstructList);
    }

    public final List<ConnectionGroupSummary> connectionGroups() {
        return this.connectionGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionGroups() ? this.connectionGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionGroupsResponse)) {
            return false;
        }
        ListConnectionGroupsResponse other = (ListConnectionGroupsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasConnectionGroups() == other.hasConnectionGroups() && Objects.equals(this.connectionGroups(), other.connectionGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectionGroupsResponse").add("NextMarker", (Object)this.nextMarker()).add("ConnectionGroups", this.hasConnectionGroups() ? this.connectionGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "ConnectionGroups": {
                return Optional.ofNullable(clazz.cast(this.connectionGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("ConnectionGroups", CONNECTION_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionGroupsResponse, T> g) {
        return obj -> g.apply((ListConnectionGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ConnectionGroupSummary> connectionGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionGroupsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.connectionGroups(model.connectionGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ConnectionGroupSummary.Builder> getConnectionGroups() {
            List<ConnectionGroupSummary.Builder> result = ConnectionGroupSummaryListCopier.copyToBuilder(this.connectionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionGroups(Collection<ConnectionGroupSummary.BuilderImpl> connectionGroups) {
            this.connectionGroups = ConnectionGroupSummaryListCopier.copyFromBuilder(connectionGroups);
        }

        @Override
        public final Builder connectionGroups(Collection<ConnectionGroupSummary> connectionGroups) {
            this.connectionGroups = ConnectionGroupSummaryListCopier.copy(connectionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionGroups(ConnectionGroupSummary ... connectionGroups) {
            this.connectionGroups(Arrays.asList(connectionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionGroups(Consumer<ConnectionGroupSummary.Builder> ... connectionGroups) {
            this.connectionGroups(Stream.of(connectionGroups).map(c -> (ConnectionGroupSummary)((ConnectionGroupSummary.Builder)ConnectionGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConnectionGroupsResponse build() {
            return new ListConnectionGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectionGroupsResponse> {
        public Builder nextMarker(String var1);

        public Builder connectionGroups(Collection<ConnectionGroupSummary> var1);

        public Builder connectionGroups(ConnectionGroupSummary ... var1);

        public Builder connectionGroups(Consumer<ConnectionGroupSummary.Builder> ... var1);
    }
}

