/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDistributionTenantRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateDistributionTenantRequest.Builder, UpdateDistributionTenantRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateDistributionTenantRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(UpdateDistributionTenantRequest::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<List<DomainItem>> DOMAINS_FIELD = SdkField
            .<List<DomainItem>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(UpdateDistributionTenantRequest::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains")
                    .unmarshallLocationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Customizations> CUSTOMIZATIONS_FIELD = SdkField
            .<Customizations> builder(MarshallingType.SDK_POJO)
            .memberName("Customizations")
            .getter(getter(UpdateDistributionTenantRequest::customizations))
            .setter(setter(Builder::customizations))
            .constructor(Customizations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customizations")
                    .unmarshallLocationName("Customizations").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(UpdateDistributionTenantRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters")
                    .unmarshallLocationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> CONNECTION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionGroupId")
            .getter(getter(UpdateDistributionTenantRequest::connectionGroupId))
            .setter(setter(Builder::connectionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroupId")
                    .unmarshallLocationName("ConnectionGroupId").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateDistributionTenantRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final SdkField<ManagedCertificateRequest> MANAGED_CERTIFICATE_REQUEST_FIELD = SdkField
            .<ManagedCertificateRequest> builder(MarshallingType.SDK_POJO)
            .memberName("ManagedCertificateRequest")
            .getter(getter(UpdateDistributionTenantRequest::managedCertificateRequest))
            .setter(setter(Builder::managedCertificateRequest))
            .constructor(ManagedCertificateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedCertificateRequest")
                    .unmarshallLocationName("ManagedCertificateRequest").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(UpdateDistributionTenantRequest::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DISTRIBUTION_ID_FIELD, DOMAINS_FIELD, CUSTOMIZATIONS_FIELD, PARAMETERS_FIELD, CONNECTION_GROUP_ID_FIELD,
            IF_MATCH_FIELD, MANAGED_CERTIFICATE_REQUEST_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String distributionId;

    private final List<DomainItem> domains;

    private final Customizations customizations;

    private final List<Parameter> parameters;

    private final String connectionGroupId;

    private final String ifMatch;

    private final ManagedCertificateRequest managedCertificateRequest;

    private final Boolean enabled;

    private UpdateDistributionTenantRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.distributionId = builder.distributionId;
        this.domains = builder.domains;
        this.customizations = builder.customizations;
        this.parameters = builder.parameters;
        this.connectionGroupId = builder.connectionGroupId;
        this.ifMatch = builder.ifMatch;
        this.managedCertificateRequest = builder.managedCertificateRequest;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ID of the distribution tenant.
     * </p>
     * 
     * @return The ID of the distribution tenant.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID for the multi-tenant distribution.
     * </p>
     * 
     * @return The ID for the multi-tenant distribution.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains to update for the distribution tenant. A domain object can contain only a domain property. You must
     * specify at least one domain. Each distribution tenant can have up to 5 domains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return The domains to update for the distribution tenant. A domain object can contain only a domain property.
     *         You must specify at least one domain. Each distribution tenant can have up to 5 domains.
     */
    public final List<DomainItem> domains() {
        return domains;
    }

    /**
     * <p>
     * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
     * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific
     * values that you can override or disable from the multi-tenant distribution that was used to create the
     * distribution tenant.
     * </p>
     * 
     * @return Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
     *         restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are
     *         specific values that you can override or disable from the multi-tenant distribution that was used to
     *         create the distribution tenant.
     */
    public final Customizations customizations() {
        return customizations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
     * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
     *         parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The ID of the target connection group.
     * </p>
     * 
     * @return The ID of the target connection group.
     */
    public final String connectionGroupId() {
        return connectionGroupId;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the distribution tenant to update.
     * This value is returned in the response of the <code>GetDistributionTenant</code> API operation.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the distribution tenant to
     *         update. This value is returned in the response of the <code>GetDistributionTenant</code> API operation.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * An object that contains the CloudFront managed ACM certificate request.
     * </p>
     * 
     * @return An object that contains the CloudFront managed ACM certificate request.
     */
    public final ManagedCertificateRequest managedCertificateRequest() {
        return managedCertificateRequest;
    }

    /**
     * <p>
     * Indicates whether the distribution tenant should be updated to an enabled state. If you update the distribution
     * tenant and it's not enabled, the distribution tenant won't serve traffic.
     * </p>
     * 
     * @return Indicates whether the distribution tenant should be updated to an enabled state. If you update the
     *         distribution tenant and it's not enabled, the distribution tenant won't serve traffic.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customizations());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(managedCertificateRequest());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionTenantRequest)) {
            return false;
        }
        UpdateDistributionTenantRequest other = (UpdateDistributionTenantRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(distributionId(), other.distributionId())
                && hasDomains() == other.hasDomains() && Objects.equals(domains(), other.domains())
                && Objects.equals(customizations(), other.customizations()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(connectionGroupId(), other.connectionGroupId()) && Objects.equals(ifMatch(), other.ifMatch())
                && Objects.equals(managedCertificateRequest(), other.managedCertificateRequest())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDistributionTenantRequest").add("Id", id()).add("DistributionId", distributionId())
                .add("Domains", hasDomains() ? domains() : null).add("Customizations", customizations())
                .add("Parameters", hasParameters() ? parameters() : null).add("ConnectionGroupId", connectionGroupId())
                .add("IfMatch", ifMatch()).add("ManagedCertificateRequest", managedCertificateRequest())
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        case "Customizations":
            return Optional.ofNullable(clazz.cast(customizations()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ConnectionGroupId":
            return Optional.ofNullable(clazz.cast(connectionGroupId()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "ManagedCertificateRequest":
            return Optional.ofNullable(clazz.cast(managedCertificateRequest()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        map.put("Customizations", CUSTOMIZATIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ConnectionGroupId", CONNECTION_GROUP_ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("ManagedCertificateRequest", MANAGED_CERTIFICATE_REQUEST_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionTenantRequest, T> g) {
        return obj -> g.apply((UpdateDistributionTenantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDistributionTenantRequest> {
        /**
         * <p>
         * The ID of the distribution tenant.
         * </p>
         * 
         * @param id
         *        The ID of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID for the multi-tenant distribution.
         * </p>
         * 
         * @param distributionId
         *        The ID for the multi-tenant distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The domains to update for the distribution tenant. A domain object can contain only a domain property. You
         * must specify at least one domain. Each distribution tenant can have up to 5 domains.
         * </p>
         * 
         * @param domains
         *        The domains to update for the distribution tenant. A domain object can contain only a domain property.
         *        You must specify at least one domain. Each distribution tenant can have up to 5 domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<DomainItem> domains);

        /**
         * <p>
         * The domains to update for the distribution tenant. A domain object can contain only a domain property. You
         * must specify at least one domain. Each distribution tenant can have up to 5 domains.
         * </p>
         * 
         * @param domains
         *        The domains to update for the distribution tenant. A domain object can contain only a domain property.
         *        You must specify at least one domain. Each distribution tenant can have up to 5 domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(DomainItem... domains);

        /**
         * <p>
         * The domains to update for the distribution tenant. A domain object can contain only a domain property. You
         * must specify at least one domain. Each distribution tenant can have up to 5 domains.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.DomainItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudfront.model.DomainItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.DomainItem.Builder#build()} is called immediately and
         * its result is passed to {@link #domains(List<DomainItem>)}.
         * 
         * @param domains
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.DomainItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domains(java.util.Collection<DomainItem>)
         */
        Builder domains(Consumer<DomainItem.Builder>... domains);

        /**
         * <p>
         * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
         * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are
         * specific values that you can override or disable from the multi-tenant distribution that was used to create
         * the distribution tenant.
         * </p>
         * 
         * @param customizations
         *        Customizations for the distribution tenant. For each distribution tenant, you can specify the
         *        geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL.
         *        These are specific values that you can override or disable from the multi-tenant distribution that was
         *        used to create the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizations(Customizations customizations);

        /**
         * <p>
         * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
         * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are
         * specific values that you can override or disable from the multi-tenant distribution that was used to create
         * the distribution tenant.
         * </p>
         * This is a convenience method that creates an instance of the {@link Customizations.Builder} avoiding the need
         * to create one manually via {@link Customizations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Customizations.Builder#build()} is called immediately and its
         * result is passed to {@link #customizations(Customizations)}.
         * 
         * @param customizations
         *        a consumer that will call methods on {@link Customizations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizations(Customizations)
         */
        default Builder customizations(Consumer<Customizations.Builder> customizations) {
            return customizations(Customizations.builder().applyMutation(customizations).build());
        }

        /**
         * <p>
         * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
         * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * </p>
         * 
         * @param parameters
         *        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A
         *        valid parameter value must exist for any parameter that is marked as required in the multi-tenant
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
         * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * </p>
         * 
         * @param parameters
         *        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A
         *        valid parameter value must exist for any parameter that is marked as required in the multi-tenant
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
         * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.Parameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudfront.model.Parameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.Parameter.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.Parameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * The ID of the target connection group.
         * </p>
         * 
         * @param connectionGroupId
         *        The ID of the target connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionGroupId(String connectionGroupId);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the distribution tenant to
         * update. This value is returned in the response of the <code>GetDistributionTenant</code> API operation.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the distribution tenant to
         *        update. This value is returned in the response of the <code>GetDistributionTenant</code> API
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * An object that contains the CloudFront managed ACM certificate request.
         * </p>
         * 
         * @param managedCertificateRequest
         *        An object that contains the CloudFront managed ACM certificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedCertificateRequest(ManagedCertificateRequest managedCertificateRequest);

        /**
         * <p>
         * An object that contains the CloudFront managed ACM certificate request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedCertificateRequest.Builder}
         * avoiding the need to create one manually via {@link ManagedCertificateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedCertificateRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #managedCertificateRequest(ManagedCertificateRequest)}.
         * 
         * @param managedCertificateRequest
         *        a consumer that will call methods on {@link ManagedCertificateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedCertificateRequest(ManagedCertificateRequest)
         */
        default Builder managedCertificateRequest(Consumer<ManagedCertificateRequest.Builder> managedCertificateRequest) {
            return managedCertificateRequest(ManagedCertificateRequest.builder().applyMutation(managedCertificateRequest).build());
        }

        /**
         * <p>
         * Indicates whether the distribution tenant should be updated to an enabled state. If you update the
         * distribution tenant and it's not enabled, the distribution tenant won't serve traffic.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the distribution tenant should be updated to an enabled state. If you update the
         *        distribution tenant and it's not enabled, the distribution tenant won't serve traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String id;

        private String distributionId;

        private List<DomainItem> domains = DefaultSdkAutoConstructList.getInstance();

        private Customizations customizations;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String connectionGroupId;

        private String ifMatch;

        private ManagedCertificateRequest managedCertificateRequest;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionTenantRequest model) {
            super(model);
            id(model.id);
            distributionId(model.distributionId);
            domains(model.domains);
            customizations(model.customizations);
            parameters(model.parameters);
            connectionGroupId(model.connectionGroupId);
            ifMatch(model.ifMatch);
            managedCertificateRequest(model.managedCertificateRequest);
            enabled(model.enabled);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDistributionId() {
            return distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final List<DomainItem.Builder> getDomains() {
            List<DomainItem.Builder> result = DomainListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<DomainItem.BuilderImpl> domains) {
            this.domains = DomainListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<DomainItem> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainItem... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainItem.Builder>... domains) {
            domains(Stream.of(domains).map(c -> DomainItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Customizations.Builder getCustomizations() {
            return customizations != null ? customizations.toBuilder() : null;
        }

        public final void setCustomizations(Customizations.BuilderImpl customizations) {
            this.customizations = customizations != null ? customizations.build() : null;
        }

        @Override
        public final Builder customizations(Customizations customizations) {
            this.customizations = customizations;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionGroupId() {
            return connectionGroupId;
        }

        public final void setConnectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
        }

        @Override
        public final Builder connectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final ManagedCertificateRequest.Builder getManagedCertificateRequest() {
            return managedCertificateRequest != null ? managedCertificateRequest.toBuilder() : null;
        }

        public final void setManagedCertificateRequest(ManagedCertificateRequest.BuilderImpl managedCertificateRequest) {
            this.managedCertificateRequest = managedCertificateRequest != null ? managedCertificateRequest.build() : null;
        }

        @Override
        public final Builder managedCertificateRequest(ManagedCertificateRequest managedCertificateRequest) {
            this.managedCertificateRequest = managedCertificateRequest;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionTenantRequest build() {
            return new UpdateDistributionTenantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
