/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a distribution tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TenantConfig implements SdkPojo, Serializable, ToCopyableBuilder<TenantConfig.Builder, TenantConfig> {
    private static final SdkField<List<ParameterDefinition>> PARAMETER_DEFINITIONS_FIELD = SdkField
            .<List<ParameterDefinition>> builder(MarshallingType.LIST)
            .memberName("ParameterDefinitions")
            .getter(getter(TenantConfig::parameterDefinitions))
            .setter(setter(Builder::parameterDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterDefinitions")
                    .unmarshallLocationName("ParameterDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ParameterDefinition> parameterDefinitions;

    private TenantConfig(BuilderImpl builder) {
        this.parameterDefinitions = builder.parameterDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterDefinitions() {
        return parameterDefinitions != null && !(parameterDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters that you specify for a distribution tenant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterDefinitions} method.
     * </p>
     * 
     * @return The parameters that you specify for a distribution tenant.
     */
    public final List<ParameterDefinition> parameterDefinitions() {
        return parameterDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterDefinitions() ? parameterDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenantConfig)) {
            return false;
        }
        TenantConfig other = (TenantConfig) obj;
        return hasParameterDefinitions() == other.hasParameterDefinitions()
                && Objects.equals(parameterDefinitions(), other.parameterDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TenantConfig")
                .add("ParameterDefinitions", hasParameterDefinitions() ? parameterDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterDefinitions":
            return Optional.ofNullable(clazz.cast(parameterDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterDefinitions", PARAMETER_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TenantConfig, T> g) {
        return obj -> g.apply((TenantConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TenantConfig> {
        /**
         * <p>
         * The parameters that you specify for a distribution tenant.
         * </p>
         * 
         * @param parameterDefinitions
         *        The parameters that you specify for a distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions);

        /**
         * <p>
         * The parameters that you specify for a distribution tenant.
         * </p>
         * 
         * @param parameterDefinitions
         *        The parameters that you specify for a distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterDefinitions(ParameterDefinition... parameterDefinitions);

        /**
         * <p>
         * The parameters that you specify for a distribution tenant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.ParameterDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudfront.model.ParameterDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.ParameterDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterDefinitions(List<ParameterDefinition>)}.
         * 
         * @param parameterDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.ParameterDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterDefinitions(java.util.Collection<ParameterDefinition>)
         */
        Builder parameterDefinitions(Consumer<ParameterDefinition.Builder>... parameterDefinitions);
    }

    static final class BuilderImpl implements Builder {
        private List<ParameterDefinition> parameterDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TenantConfig model) {
            parameterDefinitions(model.parameterDefinitions);
        }

        public final List<ParameterDefinition.Builder> getParameterDefinitions() {
            List<ParameterDefinition.Builder> result = ParameterDefinitionsCopier.copyToBuilder(this.parameterDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterDefinitions(Collection<ParameterDefinition.BuilderImpl> parameterDefinitions) {
            this.parameterDefinitions = ParameterDefinitionsCopier.copyFromBuilder(parameterDefinitions);
        }

        @Override
        public final Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = ParameterDefinitionsCopier.copy(parameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(ParameterDefinition... parameterDefinitions) {
            parameterDefinitions(Arrays.asList(parameterDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(Consumer<ParameterDefinition.Builder>... parameterDefinitions) {
            parameterDefinitions(Stream.of(parameterDefinitions).map(c -> ParameterDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TenantConfig build() {
            return new TenantConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
