/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DnsConfigurationListCopier {
    static List<DnsConfiguration> copy(Collection<? extends DnsConfiguration> dnsConfigurationListParam) {
        List<DnsConfiguration> list;
        if (dnsConfigurationListParam == null || dnsConfigurationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DnsConfiguration> modifiableList = new ArrayList<>(dnsConfigurationListParam.size());
            dnsConfigurationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DnsConfiguration> copyFromBuilder(Collection<? extends DnsConfiguration.Builder> dnsConfigurationListParam) {
        List<DnsConfiguration> list;
        if (dnsConfigurationListParam == null || dnsConfigurationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DnsConfiguration> modifiableList = new ArrayList<>(dnsConfigurationListParam.size());
            dnsConfigurationListParam.forEach(entry -> {
                DnsConfiguration member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DnsConfiguration.Builder> copyToBuilder(Collection<? extends DnsConfiguration> dnsConfigurationListParam) {
        List<DnsConfiguration.Builder> list;
        if (dnsConfigurationListParam == null || dnsConfigurationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DnsConfiguration.Builder> modifiableList = new ArrayList<>(dnsConfigurationListParam.size());
            dnsConfigurationListParam.forEach(entry -> {
                DnsConfiguration.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
