/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.ParameterDefinition;
import software.amazon.awssdk.services.cloudfront.model.ParameterDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TenantConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TenantConfig> {
    private static final SdkField<List<ParameterDefinition>> PARAMETER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterDefinitions").getter(TenantConfig.getter(TenantConfig::parameterDefinitions)).setter(TenantConfig.setter(Builder::parameterDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterDefinitions").unmarshallLocationName("ParameterDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TenantConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ParameterDefinition> parameterDefinitions;

    private TenantConfig(BuilderImpl builder) {
        this.parameterDefinitions = builder.parameterDefinitions;
    }

    public final boolean hasParameterDefinitions() {
        return this.parameterDefinitions != null && !(this.parameterDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ParameterDefinition> parameterDefinitions() {
        return this.parameterDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterDefinitions() ? this.parameterDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenantConfig)) {
            return false;
        }
        TenantConfig other = (TenantConfig)obj;
        return this.hasParameterDefinitions() == other.hasParameterDefinitions() && Objects.equals(this.parameterDefinitions(), other.parameterDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"TenantConfig").add("ParameterDefinitions", this.hasParameterDefinitions() ? this.parameterDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterDefinitions": {
                return Optional.ofNullable(clazz.cast(this.parameterDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ParameterDefinition>>> map = new HashMap<String, SdkField<List<ParameterDefinition>>>();
        map.put("ParameterDefinitions", PARAMETER_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TenantConfig, T> g) {
        return obj -> g.apply((TenantConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ParameterDefinition> parameterDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TenantConfig model) {
            this.parameterDefinitions(model.parameterDefinitions);
        }

        public final List<ParameterDefinition.Builder> getParameterDefinitions() {
            List<ParameterDefinition.Builder> result = ParameterDefinitionsCopier.copyToBuilder(this.parameterDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterDefinitions(Collection<ParameterDefinition.BuilderImpl> parameterDefinitions) {
            this.parameterDefinitions = ParameterDefinitionsCopier.copyFromBuilder(parameterDefinitions);
        }

        @Override
        public final Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = ParameterDefinitionsCopier.copy(parameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(ParameterDefinition ... parameterDefinitions) {
            this.parameterDefinitions(Arrays.asList(parameterDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(Consumer<ParameterDefinition.Builder> ... parameterDefinitions) {
            this.parameterDefinitions(Stream.of(parameterDefinitions).map(c -> (ParameterDefinition)((ParameterDefinition.Builder)ParameterDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TenantConfig build() {
            return new TenantConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TenantConfig> {
        public Builder parameterDefinitions(Collection<ParameterDefinition> var1);

        public Builder parameterDefinitions(ParameterDefinition ... var1);

        public Builder parameterDefinitions(Consumer<ParameterDefinition.Builder> ... var1);
    }
}

