/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringSchemaConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringSchemaConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(StringSchemaConfig.getter(StringSchemaConfig::comment)).setter(StringSchemaConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(StringSchemaConfig.getter(StringSchemaConfig::defaultValue)).setter(StringSchemaConfig.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").unmarshallLocationName("DefaultValue").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Required").getter(StringSchemaConfig.getter(StringSchemaConfig::required)).setter(StringSchemaConfig.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").unmarshallLocationName("Required").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, DEFAULT_VALUE_FIELD, REQUIRED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringSchemaConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final String defaultValue;
    private final Boolean required;

    private StringSchemaConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.defaultValue = builder.defaultValue;
        this.required = builder.required;
    }

    public final String comment() {
        return this.comment;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final Boolean required() {
        return this.required;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringSchemaConfig)) {
            return false;
        }
        StringSchemaConfig other = (StringSchemaConfig)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.required(), other.required());
    }

    public final String toString() {
        return ToString.builder((String)"StringSchemaConfig").add("Comment", (Object)this.comment()).add("DefaultValue", (Object)this.defaultValue()).add("Required", (Object)this.required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Comment", COMMENT_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringSchemaConfig, T> g) {
        return obj -> g.apply((StringSchemaConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String defaultValue;
        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(StringSchemaConfig model) {
            this.comment(model.comment);
            this.defaultValue(model.defaultValue);
            this.required(model.required);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public StringSchemaConfig build() {
            return new StringSchemaConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringSchemaConfig> {
        public Builder comment(String var1);

        public Builder defaultValue(String var1);

        public Builder required(Boolean var1);
    }
}

