/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A cache policy.
 * </p>
 * <p>
 * When it's attached to a cache behavior, the cache policy determines the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query
 * strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
 * </p>
 * </li>
 * <li>
 * <p>
 * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
 * </p>
 * </li>
 * </ul>
 * <p>
 * The headers, cookies, and query strings that are included in the cache key are also included in requests that
 * CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that
 * matches the request's cache key. If you want to send values to the origin but <i>not</i> include them in the cache
 * key, use <code>OriginRequestPolicy</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CachePolicy implements SdkPojo, Serializable, ToCopyableBuilder<CachePolicy.Builder, CachePolicy> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(CachePolicy::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(CachePolicy::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField
            .<CachePolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicyConfig")
            .getter(getter(CachePolicy::cachePolicyConfig))
            .setter(setter(Builder::cachePolicyConfig))
            .constructor(CachePolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig")
                    .unmarshallLocationName("CachePolicyConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, CACHE_POLICY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final CachePolicyConfig cachePolicyConfig;

    private CachePolicy(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.cachePolicyConfig = builder.cachePolicyConfig;
    }

    /**
     * <p>
     * The unique identifier for the cache policy.
     * </p>
     * 
     * @return The unique identifier for the cache policy.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time when the cache policy was last modified.
     * </p>
     * 
     * @return The date and time when the cache policy was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The cache policy configuration.
     * </p>
     * 
     * @return The cache policy configuration.
     */
    public final CachePolicyConfig cachePolicyConfig() {
        return cachePolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicy)) {
            return false;
        }
        CachePolicy other = (CachePolicy) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(cachePolicyConfig(), other.cachePolicyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CachePolicy").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("CachePolicyConfig", cachePolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CachePolicyConfig":
            return Optional.ofNullable(clazz.cast(cachePolicyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CachePolicyConfig", CACHE_POLICY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CachePolicy, T> g) {
        return obj -> g.apply((CachePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CachePolicy> {
        /**
         * <p>
         * The unique identifier for the cache policy.
         * </p>
         * 
         * @param id
         *        The unique identifier for the cache policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time when the cache policy was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when the cache policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The cache policy configuration.
         * </p>
         * 
         * @param cachePolicyConfig
         *        The cache policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig);

        /**
         * <p>
         * The cache policy configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CachePolicyConfig.Builder} avoiding the
         * need to create one manually via {@link CachePolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CachePolicyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePolicyConfig(CachePolicyConfig)}.
         * 
         * @param cachePolicyConfig
         *        a consumer that will call methods on {@link CachePolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicyConfig(CachePolicyConfig)
         */
        default Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return cachePolicyConfig(CachePolicyConfig.builder().applyMutation(cachePolicyConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private CachePolicyConfig cachePolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicy model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            cachePolicyConfig(model.cachePolicyConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return cachePolicyConfig != null ? cachePolicyConfig.toBuilder() : null;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        @Override
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        @Override
        public CachePolicy build() {
            return new CachePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
