/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultCacheBehavior
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultCacheBehavior> {
    private static final SdkField<String> TARGET_ORIGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::targetOriginId)).setter(DefaultCacheBehavior.setter(Builder::targetOriginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOriginId").unmarshallLocationName("TargetOriginId").build()}).build();
    private static final SdkField<ForwardedValues> FORWARDED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::forwardedValues)).setter(DefaultCacheBehavior.setter(Builder::forwardedValues)).constructor(ForwardedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedValues").unmarshallLocationName("ForwardedValues").build()}).build();
    private static final SdkField<TrustedSigners> TRUSTED_SIGNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::trustedSigners)).setter(DefaultCacheBehavior.setter(Builder::trustedSigners)).constructor(TrustedSigners::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedSigners").unmarshallLocationName("TrustedSigners").build()}).build();
    private static final SdkField<String> VIEWER_PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::viewerProtocolPolicyAsString)).setter(DefaultCacheBehavior.setter(Builder::viewerProtocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerProtocolPolicy").unmarshallLocationName("ViewerProtocolPolicy").build()}).build();
    private static final SdkField<Long> MIN_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::minTTL)).setter(DefaultCacheBehavior.setter(Builder::minTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTTL").unmarshallLocationName("MinTTL").build()}).build();
    private static final SdkField<AllowedMethods> ALLOWED_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::allowedMethods)).setter(DefaultCacheBehavior.setter(Builder::allowedMethods)).constructor(AllowedMethods::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethods").unmarshallLocationName("AllowedMethods").build()}).build();
    private static final SdkField<Boolean> SMOOTH_STREAMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::smoothStreaming)).setter(DefaultCacheBehavior.setter(Builder::smoothStreaming)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmoothStreaming").unmarshallLocationName("SmoothStreaming").build()}).build();
    private static final SdkField<Long> DEFAULT_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::defaultTTL)).setter(DefaultCacheBehavior.setter(Builder::defaultTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTTL").unmarshallLocationName("DefaultTTL").build()}).build();
    private static final SdkField<Long> MAX_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::maxTTL)).setter(DefaultCacheBehavior.setter(Builder::maxTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTTL").unmarshallLocationName("MaxTTL").build()}).build();
    private static final SdkField<Boolean> COMPRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::compress)).setter(DefaultCacheBehavior.setter(Builder::compress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compress").unmarshallLocationName("Compress").build()}).build();
    private static final SdkField<LambdaFunctionAssociations> LAMBDA_FUNCTION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::lambdaFunctionAssociations)).setter(DefaultCacheBehavior.setter(Builder::lambdaFunctionAssociations)).constructor(LambdaFunctionAssociations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionAssociations").unmarshallLocationName("LambdaFunctionAssociations").build()}).build();
    private static final SdkField<String> FIELD_LEVEL_ENCRYPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::fieldLevelEncryptionId)).setter(DefaultCacheBehavior.setter(Builder::fieldLevelEncryptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionId").unmarshallLocationName("FieldLevelEncryptionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ORIGIN_ID_FIELD, FORWARDED_VALUES_FIELD, TRUSTED_SIGNERS_FIELD, VIEWER_PROTOCOL_POLICY_FIELD, MIN_TTL_FIELD, ALLOWED_METHODS_FIELD, SMOOTH_STREAMING_FIELD, DEFAULT_TTL_FIELD, MAX_TTL_FIELD, COMPRESS_FIELD, LAMBDA_FUNCTION_ASSOCIATIONS_FIELD, FIELD_LEVEL_ENCRYPTION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetOriginId;
    private final ForwardedValues forwardedValues;
    private final TrustedSigners trustedSigners;
    private final String viewerProtocolPolicy;
    private final Long minTTL;
    private final AllowedMethods allowedMethods;
    private final Boolean smoothStreaming;
    private final Long defaultTTL;
    private final Long maxTTL;
    private final Boolean compress;
    private final LambdaFunctionAssociations lambdaFunctionAssociations;
    private final String fieldLevelEncryptionId;

    private DefaultCacheBehavior(BuilderImpl builder) {
        this.targetOriginId = builder.targetOriginId;
        this.forwardedValues = builder.forwardedValues;
        this.trustedSigners = builder.trustedSigners;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.minTTL = builder.minTTL;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
        this.fieldLevelEncryptionId = builder.fieldLevelEncryptionId;
    }

    public String targetOriginId() {
        return this.targetOriginId;
    }

    public ForwardedValues forwardedValues() {
        return this.forwardedValues;
    }

    public TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public ViewerProtocolPolicy viewerProtocolPolicy() {
        return ViewerProtocolPolicy.fromValue(this.viewerProtocolPolicy);
    }

    public String viewerProtocolPolicyAsString() {
        return this.viewerProtocolPolicy;
    }

    public Long minTTL() {
        return this.minTTL;
    }

    public AllowedMethods allowedMethods() {
        return this.allowedMethods;
    }

    public Boolean smoothStreaming() {
        return this.smoothStreaming;
    }

    public Long defaultTTL() {
        return this.defaultTTL;
    }

    public Long maxTTL() {
        return this.maxTTL;
    }

    public Boolean compress() {
        return this.compress;
    }

    public LambdaFunctionAssociations lambdaFunctionAssociations() {
        return this.lambdaFunctionAssociations;
    }

    public String fieldLevelEncryptionId() {
        return this.fieldLevelEncryptionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOriginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothStreaming());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.compress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLevelEncryptionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCacheBehavior)) {
            return false;
        }
        DefaultCacheBehavior other = (DefaultCacheBehavior)obj;
        return Objects.equals(this.targetOriginId(), other.targetOriginId()) && Objects.equals(this.forwardedValues(), other.forwardedValues()) && Objects.equals(this.trustedSigners(), other.trustedSigners()) && Objects.equals(this.viewerProtocolPolicyAsString(), other.viewerProtocolPolicyAsString()) && Objects.equals(this.minTTL(), other.minTTL()) && Objects.equals(this.allowedMethods(), other.allowedMethods()) && Objects.equals(this.smoothStreaming(), other.smoothStreaming()) && Objects.equals(this.defaultTTL(), other.defaultTTL()) && Objects.equals(this.maxTTL(), other.maxTTL()) && Objects.equals(this.compress(), other.compress()) && Objects.equals(this.lambdaFunctionAssociations(), other.lambdaFunctionAssociations()) && Objects.equals(this.fieldLevelEncryptionId(), other.fieldLevelEncryptionId());
    }

    public String toString() {
        return ToString.builder((String)"DefaultCacheBehavior").add("TargetOriginId", (Object)this.targetOriginId()).add("ForwardedValues", (Object)this.forwardedValues()).add("TrustedSigners", (Object)this.trustedSigners()).add("ViewerProtocolPolicy", (Object)this.viewerProtocolPolicyAsString()).add("MinTTL", (Object)this.minTTL()).add("AllowedMethods", (Object)this.allowedMethods()).add("SmoothStreaming", (Object)this.smoothStreaming()).add("DefaultTTL", (Object)this.defaultTTL()).add("MaxTTL", (Object)this.maxTTL()).add("Compress", (Object)this.compress()).add("LambdaFunctionAssociations", (Object)this.lambdaFunctionAssociations()).add("FieldLevelEncryptionId", (Object)this.fieldLevelEncryptionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetOriginId": {
                return Optional.ofNullable(clazz.cast(this.targetOriginId()));
            }
            case "ForwardedValues": {
                return Optional.ofNullable(clazz.cast(this.forwardedValues()));
            }
            case "TrustedSigners": {
                return Optional.ofNullable(clazz.cast(this.trustedSigners()));
            }
            case "ViewerProtocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.viewerProtocolPolicyAsString()));
            }
            case "MinTTL": {
                return Optional.ofNullable(clazz.cast(this.minTTL()));
            }
            case "AllowedMethods": {
                return Optional.ofNullable(clazz.cast(this.allowedMethods()));
            }
            case "SmoothStreaming": {
                return Optional.ofNullable(clazz.cast(this.smoothStreaming()));
            }
            case "DefaultTTL": {
                return Optional.ofNullable(clazz.cast(this.defaultTTL()));
            }
            case "MaxTTL": {
                return Optional.ofNullable(clazz.cast(this.maxTTL()));
            }
            case "Compress": {
                return Optional.ofNullable(clazz.cast(this.compress()));
            }
            case "LambdaFunctionAssociations": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionAssociations()));
            }
            case "FieldLevelEncryptionId": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelEncryptionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultCacheBehavior, T> g) {
        return obj -> g.apply((DefaultCacheBehavior)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetOriginId;
        private ForwardedValues forwardedValues;
        private TrustedSigners trustedSigners;
        private String viewerProtocolPolicy;
        private Long minTTL;
        private AllowedMethods allowedMethods;
        private Boolean smoothStreaming;
        private Long defaultTTL;
        private Long maxTTL;
        private Boolean compress;
        private LambdaFunctionAssociations lambdaFunctionAssociations;
        private String fieldLevelEncryptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCacheBehavior model) {
            this.targetOriginId(model.targetOriginId);
            this.forwardedValues(model.forwardedValues);
            this.trustedSigners(model.trustedSigners);
            this.viewerProtocolPolicy(model.viewerProtocolPolicy);
            this.minTTL(model.minTTL);
            this.allowedMethods(model.allowedMethods);
            this.smoothStreaming(model.smoothStreaming);
            this.defaultTTL(model.defaultTTL);
            this.maxTTL(model.maxTTL);
            this.compress(model.compress);
            this.lambdaFunctionAssociations(model.lambdaFunctionAssociations);
            this.fieldLevelEncryptionId(model.fieldLevelEncryptionId);
        }

        public final String getTargetOriginId() {
            return this.targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        public final ForwardedValues.Builder getForwardedValues() {
            return this.forwardedValues != null ? this.forwardedValues.toBuilder() : null;
        }

        @Override
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        public final void setForwardedValues(ForwardedValues.BuilderImpl forwardedValues) {
            this.forwardedValues = forwardedValues != null ? forwardedValues.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return this.trustedSigners != null ? this.trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getViewerProtocolPolicyAsString() {
            return this.viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        public final Long getMinTTL() {
            return this.minTTL;
        }

        @Override
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        public final AllowedMethods.Builder getAllowedMethods() {
            return this.allowedMethods != null ? this.allowedMethods.toBuilder() : null;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final void setAllowedMethods(AllowedMethods.BuilderImpl allowedMethods) {
            this.allowedMethods = allowedMethods != null ? allowedMethods.build() : null;
        }

        public final Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        public final Long getDefaultTTL() {
            return this.defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        public final Long getMaxTTL() {
            return this.maxTTL;
        }

        @Override
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        public final Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public final LambdaFunctionAssociations.Builder getLambdaFunctionAssociations() {
            return this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations.BuilderImpl lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations != null ? lambdaFunctionAssociations.build() : null;
        }

        public final String getFieldLevelEncryptionId() {
            return this.fieldLevelEncryptionId;
        }

        @Override
        public final Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
            return this;
        }

        public final void setFieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
        }

        public DefaultCacheBehavior build() {
            return new DefaultCacheBehavior(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultCacheBehavior> {
        public Builder targetOriginId(String var1);

        public Builder forwardedValues(ForwardedValues var1);

        default public Builder forwardedValues(Consumer<ForwardedValues.Builder> forwardedValues) {
            return this.forwardedValues((ForwardedValues)((ForwardedValues.Builder)ForwardedValues.builder().applyMutation(forwardedValues)).build());
        }

        public Builder trustedSigners(TrustedSigners var1);

        default public Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return this.trustedSigners((TrustedSigners)((TrustedSigners.Builder)TrustedSigners.builder().applyMutation(trustedSigners)).build());
        }

        public Builder viewerProtocolPolicy(String var1);

        public Builder viewerProtocolPolicy(ViewerProtocolPolicy var1);

        public Builder minTTL(Long var1);

        public Builder allowedMethods(AllowedMethods var1);

        default public Builder allowedMethods(Consumer<AllowedMethods.Builder> allowedMethods) {
            return this.allowedMethods((AllowedMethods)((AllowedMethods.Builder)AllowedMethods.builder().applyMutation(allowedMethods)).build());
        }

        public Builder smoothStreaming(Boolean var1);

        public Builder defaultTTL(Long var1);

        public Builder maxTTL(Long var1);

        public Builder compress(Boolean var1);

        public Builder lambdaFunctionAssociations(LambdaFunctionAssociations var1);

        default public Builder lambdaFunctionAssociations(Consumer<LambdaFunctionAssociations.Builder> lambdaFunctionAssociations) {
            return this.lambdaFunctionAssociations((LambdaFunctionAssociations)((LambdaFunctionAssociations.Builder)LambdaFunctionAssociations.builder().applyMutation(lambdaFunctionAssociations)).build());
        }

        public Builder fieldLevelEncryptionId(String var1);
    }
}

