/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;

public class ListInvalidationsIterable
implements SdkIterable<ListInvalidationsResponse> {
    private final CloudFrontClient client;
    private final ListInvalidationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvalidationsIterable(CloudFrontClient client, ListInvalidationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInvalidationsResponseFetcher();
    }

    public Iterator<ListInvalidationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvalidationSummary> items() {
        Function<ListInvalidationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invalidationList() != null && response.invalidationList().items() != null) {
                return response.invalidationList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListInvalidationsIterable resume(ListInvalidationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInvalidationsIterable(this.client, (ListInvalidationsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.invalidationList().nextMarker()).build()));
        }
        return new ListInvalidationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInvalidationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInvalidationsResponseFetcher
    implements SyncPageFetcher<ListInvalidationsResponse> {
        private ListInvalidationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvalidationsResponse previousPage) {
            return previousPage.invalidationList().isTruncated();
        }

        public ListInvalidationsResponse nextPage(ListInvalidationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvalidationsIterable.this.client.listInvalidations(ListInvalidationsIterable.this.firstRequest);
            }
            return ListInvalidationsIterable.this.client.listInvalidations((ListInvalidationsRequest)((Object)ListInvalidationsIterable.this.firstRequest.toBuilder().marker(previousPage.invalidationList().nextMarker()).build()));
        }
    }
}

