/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContinuousDeploymentPoliciesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListContinuousDeploymentPoliciesResponse.Builder, ListContinuousDeploymentPoliciesResponse> {
    private static final SdkField<ContinuousDeploymentPolicyList> CONTINUOUS_DEPLOYMENT_POLICY_LIST_FIELD = SdkField
            .<ContinuousDeploymentPolicyList> builder(MarshallingType.SDK_POJO)
            .memberName("ContinuousDeploymentPolicyList")
            .getter(getter(ListContinuousDeploymentPoliciesResponse::continuousDeploymentPolicyList))
            .setter(setter(Builder::continuousDeploymentPolicyList))
            .constructor(ContinuousDeploymentPolicyList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicyList")
                    .unmarshallLocationName("ContinuousDeploymentPolicyList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTINUOUS_DEPLOYMENT_POLICY_LIST_FIELD));

    private final ContinuousDeploymentPolicyList continuousDeploymentPolicyList;

    private ListContinuousDeploymentPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.continuousDeploymentPolicyList = builder.continuousDeploymentPolicyList;
    }

    /**
     * <p>
     * A list of continuous deployment policies.
     * </p>
     * 
     * @return A list of continuous deployment policies.
     */
    public final ContinuousDeploymentPolicyList continuousDeploymentPolicyList() {
        return continuousDeploymentPolicyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(continuousDeploymentPolicyList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContinuousDeploymentPoliciesResponse)) {
            return false;
        }
        ListContinuousDeploymentPoliciesResponse other = (ListContinuousDeploymentPoliciesResponse) obj;
        return Objects.equals(continuousDeploymentPolicyList(), other.continuousDeploymentPolicyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContinuousDeploymentPoliciesResponse")
                .add("ContinuousDeploymentPolicyList", continuousDeploymentPolicyList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuousDeploymentPolicyList":
            return Optional.ofNullable(clazz.cast(continuousDeploymentPolicyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContinuousDeploymentPoliciesResponse, T> g) {
        return obj -> g.apply((ListContinuousDeploymentPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListContinuousDeploymentPoliciesResponse> {
        /**
         * <p>
         * A list of continuous deployment policies.
         * </p>
         * 
         * @param continuousDeploymentPolicyList
         *        A list of continuous deployment policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousDeploymentPolicyList(ContinuousDeploymentPolicyList continuousDeploymentPolicyList);

        /**
         * <p>
         * A list of continuous deployment policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContinuousDeploymentPolicyList.Builder}
         * avoiding the need to create one manually via {@link ContinuousDeploymentPolicyList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContinuousDeploymentPolicyList.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #continuousDeploymentPolicyList(ContinuousDeploymentPolicyList)}.
         * 
         * @param continuousDeploymentPolicyList
         *        a consumer that will call methods on {@link ContinuousDeploymentPolicyList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousDeploymentPolicyList(ContinuousDeploymentPolicyList)
         */
        default Builder continuousDeploymentPolicyList(
                Consumer<ContinuousDeploymentPolicyList.Builder> continuousDeploymentPolicyList) {
            return continuousDeploymentPolicyList(ContinuousDeploymentPolicyList.builder()
                    .applyMutation(continuousDeploymentPolicyList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private ContinuousDeploymentPolicyList continuousDeploymentPolicyList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContinuousDeploymentPoliciesResponse model) {
            super(model);
            continuousDeploymentPolicyList(model.continuousDeploymentPolicyList);
        }

        public final ContinuousDeploymentPolicyList.Builder getContinuousDeploymentPolicyList() {
            return continuousDeploymentPolicyList != null ? continuousDeploymentPolicyList.toBuilder() : null;
        }

        public final void setContinuousDeploymentPolicyList(
                ContinuousDeploymentPolicyList.BuilderImpl continuousDeploymentPolicyList) {
            this.continuousDeploymentPolicyList = continuousDeploymentPolicyList != null ? continuousDeploymentPolicyList.build()
                    : null;
        }

        @Override
        public final Builder continuousDeploymentPolicyList(ContinuousDeploymentPolicyList continuousDeploymentPolicyList) {
            this.continuousDeploymentPolicyList = continuousDeploymentPolicyList;
            return this;
        }

        @Override
        public ListContinuousDeploymentPoliciesResponse build() {
            return new ListContinuousDeploymentPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
