/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SSLSupportMethod {
    SNI_ONLY("sni-only"),
    VIP("vip"),
    STATIC_IP("static-ip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SSLSupportMethod> VALUE_MAP;
    private final String value;

    private SSLSupportMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SSLSupportMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SSLSupportMethod> knownValues() {
        EnumSet<SSLSupportMethod> knownValues = EnumSet.allOf(SSLSupportMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SSLSupportMethod.class, SSLSupportMethod::toString);
    }
}

