/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ICPRecordalStatus {
    APPROVED("APPROVED"),
    SUSPENDED("SUSPENDED"),
    PENDING("PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ICPRecordalStatus> VALUE_MAP;
    private final String value;

    private ICPRecordalStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICPRecordalStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICPRecordalStatus> knownValues() {
        EnumSet<ICPRecordalStatus> knownValues = EnumSet.allOf(ICPRecordalStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ICPRecordalStatus.class, ICPRecordalStatus::toString);
    }
}

