/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.internal.url;

import java.util.Objects;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.cloudfront.url.SignedUrl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
@ThreadSafe
@SdkInternalApi
public final class DefaultSignedUrl
implements SignedUrl,
ToCopyableBuilder<Builder, DefaultSignedUrl> {
    private final String protocol;
    private final String domain;
    private final String encodedPath;
    private final String url;

    private DefaultSignedUrl(Builder builder) {
        this.protocol = builder.protocol;
        this.domain = builder.domain;
        this.encodedPath = builder.encodedPath;
        this.url = builder.url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return ToString.builder((String)"DefaultSignedUrl").add("url", (Object)this.url).build();
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public String encodedPath() {
        return this.encodedPath;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public SdkHttpRequest createHttpGetRequest() {
        return (SdkHttpRequest)SdkHttpRequest.builder().encodedPath(this.encodedPath).host(this.domain).method(SdkHttpMethod.GET).protocol(this.protocol).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSignedUrl signedUrl = (DefaultSignedUrl)o;
        return Objects.equals(this.protocol, signedUrl.protocol) && Objects.equals(this.domain, signedUrl.domain) && Objects.equals(this.encodedPath, signedUrl.encodedPath) && Objects.equals(this.url, signedUrl.url);
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (this.encodedPath != null ? this.encodedPath.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements CopyableBuilder<Builder, DefaultSignedUrl> {
        private String protocol;
        private String domain;
        private String encodedPath;
        private String url;

        private Builder() {
        }

        private Builder(DefaultSignedUrl signedUrl) {
            this.protocol = signedUrl.protocol;
            this.domain = signedUrl.domain;
            this.encodedPath = signedUrl.encodedPath;
            this.url = signedUrl.url;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder encodedPath(String encodedPath) {
            this.encodedPath = encodedPath;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public DefaultSignedUrl build() {
            return new DefaultSignedUrl(this);
        }
    }
}

