/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCorsConfig;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseHeadersPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseHeadersPolicyConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(ResponseHeadersPolicyConfig.getter(ResponseHeadersPolicyConfig::comment)).setter(ResponseHeadersPolicyConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResponseHeadersPolicyConfig.getter(ResponseHeadersPolicyConfig::name)).setter(ResponseHeadersPolicyConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<ResponseHeadersPolicyCorsConfig> CORS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CorsConfig").getter(ResponseHeadersPolicyConfig.getter(ResponseHeadersPolicyConfig::corsConfig)).setter(ResponseHeadersPolicyConfig.setter(Builder::corsConfig)).constructor(ResponseHeadersPolicyCorsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorsConfig").unmarshallLocationName("CorsConfig").build()}).build();
    private static final SdkField<ResponseHeadersPolicySecurityHeadersConfig> SECURITY_HEADERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityHeadersConfig").getter(ResponseHeadersPolicyConfig.getter(ResponseHeadersPolicyConfig::securityHeadersConfig)).setter(ResponseHeadersPolicyConfig.setter(Builder::securityHeadersConfig)).constructor(ResponseHeadersPolicySecurityHeadersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityHeadersConfig").unmarshallLocationName("SecurityHeadersConfig").build()}).build();
    private static final SdkField<ResponseHeadersPolicyCustomHeadersConfig> CUSTOM_HEADERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomHeadersConfig").getter(ResponseHeadersPolicyConfig.getter(ResponseHeadersPolicyConfig::customHeadersConfig)).setter(ResponseHeadersPolicyConfig.setter(Builder::customHeadersConfig)).constructor(ResponseHeadersPolicyCustomHeadersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomHeadersConfig").unmarshallLocationName("CustomHeadersConfig").build()}).build();
    private static final SdkField<ResponseHeadersPolicyServerTimingHeadersConfig> SERVER_TIMING_HEADERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerTimingHeadersConfig").getter(ResponseHeadersPolicyConfig.getter(ResponseHeadersPolicyConfig::serverTimingHeadersConfig)).setter(ResponseHeadersPolicyConfig.setter(Builder::serverTimingHeadersConfig)).constructor(ResponseHeadersPolicyServerTimingHeadersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTimingHeadersConfig").unmarshallLocationName("ServerTimingHeadersConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, NAME_FIELD, CORS_CONFIG_FIELD, SECURITY_HEADERS_CONFIG_FIELD, CUSTOM_HEADERS_CONFIG_FIELD, SERVER_TIMING_HEADERS_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final String name;
    private final ResponseHeadersPolicyCorsConfig corsConfig;
    private final ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig;
    private final ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig;
    private final ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig;

    private ResponseHeadersPolicyConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.name = builder.name;
        this.corsConfig = builder.corsConfig;
        this.securityHeadersConfig = builder.securityHeadersConfig;
        this.customHeadersConfig = builder.customHeadersConfig;
        this.serverTimingHeadersConfig = builder.serverTimingHeadersConfig;
    }

    public final String comment() {
        return this.comment;
    }

    public final String name() {
        return this.name;
    }

    public final ResponseHeadersPolicyCorsConfig corsConfig() {
        return this.corsConfig;
    }

    public final ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig() {
        return this.securityHeadersConfig;
    }

    public final ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig() {
        return this.customHeadersConfig;
    }

    public final ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig() {
        return this.serverTimingHeadersConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.corsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityHeadersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.customHeadersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTimingHeadersConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyConfig)) {
            return false;
        }
        ResponseHeadersPolicyConfig other = (ResponseHeadersPolicyConfig)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.corsConfig(), other.corsConfig()) && Objects.equals(this.securityHeadersConfig(), other.securityHeadersConfig()) && Objects.equals(this.customHeadersConfig(), other.customHeadersConfig()) && Objects.equals(this.serverTimingHeadersConfig(), other.serverTimingHeadersConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseHeadersPolicyConfig").add("Comment", (Object)this.comment()).add("Name", (Object)this.name()).add("CorsConfig", (Object)this.corsConfig()).add("SecurityHeadersConfig", (Object)this.securityHeadersConfig()).add("CustomHeadersConfig", (Object)this.customHeadersConfig()).add("ServerTimingHeadersConfig", (Object)this.serverTimingHeadersConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CorsConfig": {
                return Optional.ofNullable(clazz.cast(this.corsConfig()));
            }
            case "SecurityHeadersConfig": {
                return Optional.ofNullable(clazz.cast(this.securityHeadersConfig()));
            }
            case "CustomHeadersConfig": {
                return Optional.ofNullable(clazz.cast(this.customHeadersConfig()));
            }
            case "ServerTimingHeadersConfig": {
                return Optional.ofNullable(clazz.cast(this.serverTimingHeadersConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyConfig, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String name;
        private ResponseHeadersPolicyCorsConfig corsConfig;
        private ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig;
        private ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig;
        private ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyConfig model) {
            this.comment(model.comment);
            this.name(model.name);
            this.corsConfig(model.corsConfig);
            this.securityHeadersConfig(model.securityHeadersConfig);
            this.customHeadersConfig(model.customHeadersConfig);
            this.serverTimingHeadersConfig(model.serverTimingHeadersConfig);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ResponseHeadersPolicyCorsConfig.Builder getCorsConfig() {
            return this.corsConfig != null ? this.corsConfig.toBuilder() : null;
        }

        public final void setCorsConfig(ResponseHeadersPolicyCorsConfig.BuilderImpl corsConfig) {
            this.corsConfig = corsConfig != null ? corsConfig.build() : null;
        }

        @Override
        public final Builder corsConfig(ResponseHeadersPolicyCorsConfig corsConfig) {
            this.corsConfig = corsConfig;
            return this;
        }

        public final ResponseHeadersPolicySecurityHeadersConfig.Builder getSecurityHeadersConfig() {
            return this.securityHeadersConfig != null ? this.securityHeadersConfig.toBuilder() : null;
        }

        public final void setSecurityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig.BuilderImpl securityHeadersConfig) {
            this.securityHeadersConfig = securityHeadersConfig != null ? securityHeadersConfig.build() : null;
        }

        @Override
        public final Builder securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig) {
            this.securityHeadersConfig = securityHeadersConfig;
            return this;
        }

        public final ResponseHeadersPolicyCustomHeadersConfig.Builder getCustomHeadersConfig() {
            return this.customHeadersConfig != null ? this.customHeadersConfig.toBuilder() : null;
        }

        public final void setCustomHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig.BuilderImpl customHeadersConfig) {
            this.customHeadersConfig = customHeadersConfig != null ? customHeadersConfig.build() : null;
        }

        @Override
        public final Builder customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig) {
            this.customHeadersConfig = customHeadersConfig;
            return this;
        }

        public final ResponseHeadersPolicyServerTimingHeadersConfig.Builder getServerTimingHeadersConfig() {
            return this.serverTimingHeadersConfig != null ? this.serverTimingHeadersConfig.toBuilder() : null;
        }

        public final void setServerTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig.BuilderImpl serverTimingHeadersConfig) {
            this.serverTimingHeadersConfig = serverTimingHeadersConfig != null ? serverTimingHeadersConfig.build() : null;
        }

        @Override
        public final Builder serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig) {
            this.serverTimingHeadersConfig = serverTimingHeadersConfig;
            return this;
        }

        public ResponseHeadersPolicyConfig build() {
            return new ResponseHeadersPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseHeadersPolicyConfig> {
        public Builder comment(String var1);

        public Builder name(String var1);

        public Builder corsConfig(ResponseHeadersPolicyCorsConfig var1);

        default public Builder corsConfig(Consumer<ResponseHeadersPolicyCorsConfig.Builder> corsConfig) {
            return this.corsConfig((ResponseHeadersPolicyCorsConfig)((ResponseHeadersPolicyCorsConfig.Builder)ResponseHeadersPolicyCorsConfig.builder().applyMutation(corsConfig)).build());
        }

        public Builder securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig var1);

        default public Builder securityHeadersConfig(Consumer<ResponseHeadersPolicySecurityHeadersConfig.Builder> securityHeadersConfig) {
            return this.securityHeadersConfig((ResponseHeadersPolicySecurityHeadersConfig)((ResponseHeadersPolicySecurityHeadersConfig.Builder)ResponseHeadersPolicySecurityHeadersConfig.builder().applyMutation(securityHeadersConfig)).build());
        }

        public Builder customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig var1);

        default public Builder customHeadersConfig(Consumer<ResponseHeadersPolicyCustomHeadersConfig.Builder> customHeadersConfig) {
            return this.customHeadersConfig((ResponseHeadersPolicyCustomHeadersConfig)((ResponseHeadersPolicyCustomHeadersConfig.Builder)ResponseHeadersPolicyCustomHeadersConfig.builder().applyMutation(customHeadersConfig)).build());
        }

        public Builder serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig var1);

        default public Builder serverTimingHeadersConfig(Consumer<ResponseHeadersPolicyServerTimingHeadersConfig.Builder> serverTimingHeadersConfig) {
            return this.serverTimingHeadersConfig((ResponseHeadersPolicyServerTimingHeadersConfig)((ResponseHeadersPolicyServerTimingHeadersConfig.Builder)ResponseHeadersPolicyServerTimingHeadersConfig.builder().applyMutation(serverTimingHeadersConfig)).build());
        }
    }
}

