/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFieldLevelEncryptionProfileResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, UpdateFieldLevelEncryptionProfileResponse> {
    private static final SdkField<FieldLevelEncryptionProfile> FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldLevelEncryptionProfile").getter(UpdateFieldLevelEncryptionProfileResponse.getter(UpdateFieldLevelEncryptionProfileResponse::fieldLevelEncryptionProfile)).setter(UpdateFieldLevelEncryptionProfileResponse.setter(Builder::fieldLevelEncryptionProfile)).constructor(FieldLevelEncryptionProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfile").unmarshallLocationName("FieldLevelEncryptionProfile").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(UpdateFieldLevelEncryptionProfileResponse.getter(UpdateFieldLevelEncryptionProfileResponse::eTag)).setter(UpdateFieldLevelEncryptionProfileResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD, E_TAG_FIELD));
    private final FieldLevelEncryptionProfile fieldLevelEncryptionProfile;
    private final String eTag;

    private UpdateFieldLevelEncryptionProfileResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionProfile = builder.fieldLevelEncryptionProfile;
        this.eTag = builder.eTag;
    }

    public final FieldLevelEncryptionProfile fieldLevelEncryptionProfile() {
        return this.fieldLevelEncryptionProfile;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLevelEncryptionProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFieldLevelEncryptionProfileResponse)) {
            return false;
        }
        UpdateFieldLevelEncryptionProfileResponse other = (UpdateFieldLevelEncryptionProfileResponse)((Object)obj);
        return Objects.equals(this.fieldLevelEncryptionProfile(), other.fieldLevelEncryptionProfile()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFieldLevelEncryptionProfileResponse").add("FieldLevelEncryptionProfile", (Object)this.fieldLevelEncryptionProfile()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldLevelEncryptionProfile": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelEncryptionProfile()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFieldLevelEncryptionProfileResponse, T> g) {
        return obj -> g.apply((UpdateFieldLevelEncryptionProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private FieldLevelEncryptionProfile fieldLevelEncryptionProfile;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFieldLevelEncryptionProfileResponse model) {
            super(model);
            this.fieldLevelEncryptionProfile(model.fieldLevelEncryptionProfile);
            this.eTag(model.eTag);
        }

        public final FieldLevelEncryptionProfile.Builder getFieldLevelEncryptionProfile() {
            return this.fieldLevelEncryptionProfile != null ? this.fieldLevelEncryptionProfile.toBuilder() : null;
        }

        public final void setFieldLevelEncryptionProfile(FieldLevelEncryptionProfile.BuilderImpl fieldLevelEncryptionProfile) {
            this.fieldLevelEncryptionProfile = fieldLevelEncryptionProfile != null ? fieldLevelEncryptionProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder fieldLevelEncryptionProfile(FieldLevelEncryptionProfile fieldLevelEncryptionProfile) {
            this.fieldLevelEncryptionProfile = fieldLevelEncryptionProfile;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        @Transient
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public UpdateFieldLevelEncryptionProfileResponse build() {
            return new UpdateFieldLevelEncryptionProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFieldLevelEncryptionProfileResponse> {
        public Builder fieldLevelEncryptionProfile(FieldLevelEncryptionProfile var1);

        default public Builder fieldLevelEncryptionProfile(Consumer<FieldLevelEncryptionProfile.Builder> fieldLevelEncryptionProfile) {
            return this.fieldLevelEncryptionProfile((FieldLevelEncryptionProfile)((FieldLevelEncryptionProfile.Builder)FieldLevelEncryptionProfile.builder().applyMutation(fieldLevelEncryptionProfile)).build());
        }

        public Builder eTag(String var1);
    }
}

