/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the
 * header’s value.
 * </p>
 * <p>
 * For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a
 * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security"
 * >Strict-Transport-Security</a> in the MDN Web Docs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyStrictTransportSecurity implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyStrictTransportSecurity.Builder, ResponseHeadersPolicyStrictTransportSecurity> {
    private static final SdkField<Boolean> OVERRIDE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Override")
            .getter(getter(ResponseHeadersPolicyStrictTransportSecurity::override))
            .setter(setter(Builder::override))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override")
                    .unmarshallLocationName("Override").build()).build();

    private static final SdkField<Boolean> INCLUDE_SUBDOMAINS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeSubdomains")
            .getter(getter(ResponseHeadersPolicyStrictTransportSecurity::includeSubdomains))
            .setter(setter(Builder::includeSubdomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeSubdomains")
                    .unmarshallLocationName("IncludeSubdomains").build()).build();

    private static final SdkField<Boolean> PRELOAD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Preload")
            .getter(getter(ResponseHeadersPolicyStrictTransportSecurity::preload))
            .setter(setter(Builder::preload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preload")
                    .unmarshallLocationName("Preload").build()).build();

    private static final SdkField<Integer> ACCESS_CONTROL_MAX_AGE_SEC_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AccessControlMaxAgeSec")
            .getter(getter(ResponseHeadersPolicyStrictTransportSecurity::accessControlMaxAgeSec))
            .setter(setter(Builder::accessControlMaxAgeSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlMaxAgeSec")
                    .unmarshallLocationName("AccessControlMaxAgeSec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_FIELD,
            INCLUDE_SUBDOMAINS_FIELD, PRELOAD_FIELD, ACCESS_CONTROL_MAX_AGE_SEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean override;

    private final Boolean includeSubdomains;

    private final Boolean preload;

    private final Integer accessControlMaxAgeSec;

    private ResponseHeadersPolicyStrictTransportSecurity(BuilderImpl builder) {
        this.override = builder.override;
        this.includeSubdomains = builder.includeSubdomains;
        this.preload = builder.preload;
        this.accessControlMaxAgeSec = builder.accessControlMaxAgeSec;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP response
     * header received from the origin with the one specified in this response headers policy.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP
     *         response header received from the origin with the one specified in this response headers policy.
     */
    public final Boolean override() {
        return override;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the
     * <code>Strict-Transport-Security</code> HTTP response header.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the
     *         <code>Strict-Transport-Security</code> HTTP response header.
     */
    public final Boolean includeSubdomains() {
        return includeSubdomains;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
     * <code>Strict-Transport-Security</code> HTTP response header.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
     *         <code>Strict-Transport-Security</code> HTTP response header.
     */
    public final Boolean preload() {
        return preload;
    }

    /**
     * <p>
     * A number that CloudFront uses as the value for the <code>max-age</code> directive in the
     * <code>Strict-Transport-Security</code> HTTP response header.
     * </p>
     * 
     * @return A number that CloudFront uses as the value for the <code>max-age</code> directive in the
     *         <code>Strict-Transport-Security</code> HTTP response header.
     */
    public final Integer accessControlMaxAgeSec() {
        return accessControlMaxAgeSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(override());
        hashCode = 31 * hashCode + Objects.hashCode(includeSubdomains());
        hashCode = 31 * hashCode + Objects.hashCode(preload());
        hashCode = 31 * hashCode + Objects.hashCode(accessControlMaxAgeSec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyStrictTransportSecurity)) {
            return false;
        }
        ResponseHeadersPolicyStrictTransportSecurity other = (ResponseHeadersPolicyStrictTransportSecurity) obj;
        return Objects.equals(override(), other.override()) && Objects.equals(includeSubdomains(), other.includeSubdomains())
                && Objects.equals(preload(), other.preload())
                && Objects.equals(accessControlMaxAgeSec(), other.accessControlMaxAgeSec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyStrictTransportSecurity").add("Override", override())
                .add("IncludeSubdomains", includeSubdomains()).add("Preload", preload())
                .add("AccessControlMaxAgeSec", accessControlMaxAgeSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Override":
            return Optional.ofNullable(clazz.cast(override()));
        case "IncludeSubdomains":
            return Optional.ofNullable(clazz.cast(includeSubdomains()));
        case "Preload":
            return Optional.ofNullable(clazz.cast(preload()));
        case "AccessControlMaxAgeSec":
            return Optional.ofNullable(clazz.cast(accessControlMaxAgeSec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyStrictTransportSecurity, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyStrictTransportSecurity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyStrictTransportSecurity> {
        /**
         * <p>
         * A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP
         * response header received from the origin with the one specified in this response headers policy.
         * </p>
         * 
         * @param override
         *        A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP
         *        response header received from the origin with the one specified in this response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder override(Boolean override);

        /**
         * <p>
         * A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the
         * <code>Strict-Transport-Security</code> HTTP response header.
         * </p>
         * 
         * @param includeSubdomains
         *        A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in
         *        the <code>Strict-Transport-Security</code> HTTP response header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSubdomains(Boolean includeSubdomains);

        /**
         * <p>
         * A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
         * <code>Strict-Transport-Security</code> HTTP response header.
         * </p>
         * 
         * @param preload
         *        A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
         *        <code>Strict-Transport-Security</code> HTTP response header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preload(Boolean preload);

        /**
         * <p>
         * A number that CloudFront uses as the value for the <code>max-age</code> directive in the
         * <code>Strict-Transport-Security</code> HTTP response header.
         * </p>
         * 
         * @param accessControlMaxAgeSec
         *        A number that CloudFront uses as the value for the <code>max-age</code> directive in the
         *        <code>Strict-Transport-Security</code> HTTP response header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlMaxAgeSec(Integer accessControlMaxAgeSec);
    }

    static final class BuilderImpl implements Builder {
        private Boolean override;

        private Boolean includeSubdomains;

        private Boolean preload;

        private Integer accessControlMaxAgeSec;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyStrictTransportSecurity model) {
            override(model.override);
            includeSubdomains(model.includeSubdomains);
            preload(model.preload);
            accessControlMaxAgeSec(model.accessControlMaxAgeSec);
        }

        public final Boolean getOverride() {
            return override;
        }

        public final void setOverride(Boolean override) {
            this.override = override;
        }

        @Override
        @Transient
        public final Builder override(Boolean override) {
            this.override = override;
            return this;
        }

        public final Boolean getIncludeSubdomains() {
            return includeSubdomains;
        }

        public final void setIncludeSubdomains(Boolean includeSubdomains) {
            this.includeSubdomains = includeSubdomains;
        }

        @Override
        @Transient
        public final Builder includeSubdomains(Boolean includeSubdomains) {
            this.includeSubdomains = includeSubdomains;
            return this;
        }

        public final Boolean getPreload() {
            return preload;
        }

        public final void setPreload(Boolean preload) {
            this.preload = preload;
        }

        @Override
        @Transient
        public final Builder preload(Boolean preload) {
            this.preload = preload;
            return this;
        }

        public final Integer getAccessControlMaxAgeSec() {
            return accessControlMaxAgeSec;
        }

        public final void setAccessControlMaxAgeSec(Integer accessControlMaxAgeSec) {
            this.accessControlMaxAgeSec = accessControlMaxAgeSec;
        }

        @Override
        @Transient
        public final Builder accessControlMaxAgeSec(Integer accessControlMaxAgeSec) {
            this.accessControlMaxAgeSec = accessControlMaxAgeSec;
            return this;
        }

        @Override
        public ResponseHeadersPolicyStrictTransportSecurity build() {
            return new ResponseHeadersPolicyStrictTransportSecurity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
