/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An alias (also called a CNAME) and the CloudFront distribution and Amazon Web Services account ID that it’s
 * associated with. The distribution and account IDs are partially hidden, which allows you to identify the
 * distributions and accounts that you own, but helps to protect the information of ones that you don’t own.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictingAlias implements SdkPojo, Serializable,
        ToCopyableBuilder<ConflictingAlias.Builder, ConflictingAlias> {
    private static final SdkField<String> ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Alias")
            .getter(getter(ConflictingAlias::alias))
            .setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias")
                    .unmarshallLocationName("Alias").build()).build();

    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(ConflictingAlias::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(ConflictingAlias::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId")
                    .unmarshallLocationName("AccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            DISTRIBUTION_ID_FIELD, ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String distributionId;

    private final String accountId;

    private ConflictingAlias(BuilderImpl builder) {
        this.alias = builder.alias;
        this.distributionId = builder.distributionId;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * An alias (also called a CNAME).
     * </p>
     * 
     * @return An alias (also called a CNAME).
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The (partially hidden) ID of the CloudFront distribution associated with the alias.
     * </p>
     * 
     * @return The (partially hidden) ID of the CloudFront distribution associated with the alias.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s associated with
     * the alias.
     * </p>
     * 
     * @return The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s associated
     *         with the alias.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictingAlias)) {
            return false;
        }
        ConflictingAlias other = (ConflictingAlias) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConflictingAlias").add("Alias", alias()).add("DistributionId", distributionId())
                .add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictingAlias, T> g) {
        return obj -> g.apply((ConflictingAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictingAlias> {
        /**
         * <p>
         * An alias (also called a CNAME).
         * </p>
         * 
         * @param alias
         *        An alias (also called a CNAME).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The (partially hidden) ID of the CloudFront distribution associated with the alias.
         * </p>
         * 
         * @param distributionId
         *        The (partially hidden) ID of the CloudFront distribution associated with the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s associated
         * with the alias.
         * </p>
         * 
         * @param accountId
         *        The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s
         *        associated with the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String distributionId;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictingAlias model) {
            alias(model.alias);
            distributionId(model.distributionId);
            accountId(model.accountId);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getDistributionId() {
            return distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        @Transient
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public ConflictingAlias build() {
            return new ConflictingAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
