/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOriginRequestPolicyConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetOriginRequestPolicyConfigResponse> {
    private static final SdkField<OriginRequestPolicyConfig> ORIGIN_REQUEST_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginRequestPolicyConfig").getter(GetOriginRequestPolicyConfigResponse.getter(GetOriginRequestPolicyConfigResponse::originRequestPolicyConfig)).setter(GetOriginRequestPolicyConfigResponse.setter(Builder::originRequestPolicyConfig)).constructor(OriginRequestPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyConfig").unmarshallLocationName("OriginRequestPolicyConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetOriginRequestPolicyConfigResponse.getter(GetOriginRequestPolicyConfigResponse::eTag)).setter(GetOriginRequestPolicyConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_REQUEST_POLICY_CONFIG_FIELD, E_TAG_FIELD));
    private final OriginRequestPolicyConfig originRequestPolicyConfig;
    private final String eTag;

    private GetOriginRequestPolicyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicyConfig = builder.originRequestPolicyConfig;
        this.eTag = builder.eTag;
    }

    public final OriginRequestPolicyConfig originRequestPolicyConfig() {
        return this.originRequestPolicyConfig;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originRequestPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginRequestPolicyConfigResponse)) {
            return false;
        }
        GetOriginRequestPolicyConfigResponse other = (GetOriginRequestPolicyConfigResponse)((Object)obj);
        return Objects.equals(this.originRequestPolicyConfig(), other.originRequestPolicyConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetOriginRequestPolicyConfigResponse").add("OriginRequestPolicyConfig", (Object)this.originRequestPolicyConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginRequestPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.originRequestPolicyConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOriginRequestPolicyConfigResponse, T> g) {
        return obj -> g.apply((GetOriginRequestPolicyConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private OriginRequestPolicyConfig originRequestPolicyConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginRequestPolicyConfigResponse model) {
            super(model);
            this.originRequestPolicyConfig(model.originRequestPolicyConfig);
            this.eTag(model.eTag);
        }

        public final OriginRequestPolicyConfig.Builder getOriginRequestPolicyConfig() {
            return this.originRequestPolicyConfig != null ? this.originRequestPolicyConfig.toBuilder() : null;
        }

        @Override
        public final Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        public final void setOriginRequestPolicyConfig(OriginRequestPolicyConfig.BuilderImpl originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig != null ? originRequestPolicyConfig.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetOriginRequestPolicyConfigResponse build() {
            return new GetOriginRequestPolicyConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOriginRequestPolicyConfigResponse> {
        public Builder originRequestPolicyConfig(OriginRequestPolicyConfig var1);

        default public Builder originRequestPolicyConfig(Consumer<OriginRequestPolicyConfig.Builder> originRequestPolicyConfig) {
            return this.originRequestPolicyConfig((OriginRequestPolicyConfig)((OriginRequestPolicyConfig.Builder)OriginRequestPolicyConfig.builder().applyMutation(originRequestPolicyConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

