/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Origin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Origin> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(S3Origin.getter(S3Origin::domainName)).setter(S3Origin.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").unmarshallLocationName("DomainName").build()}).build();
    private static final SdkField<String> ORIGIN_ACCESS_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginAccessIdentity").getter(S3Origin.getter(S3Origin::originAccessIdentity)).setter(S3Origin.setter(Builder::originAccessIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessIdentity").unmarshallLocationName("OriginAccessIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ORIGIN_ACCESS_IDENTITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String originAccessIdentity;

    private S3Origin(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.originAccessIdentity = builder.originAccessIdentity;
    }

    public String domainName() {
        return this.domainName;
    }

    public String originAccessIdentity() {
        return this.originAccessIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessIdentity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Origin)) {
            return false;
        }
        S3Origin other = (S3Origin)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.originAccessIdentity(), other.originAccessIdentity());
    }

    public String toString() {
        return ToString.builder((String)"S3Origin").add("DomainName", (Object)this.domainName()).add("OriginAccessIdentity", (Object)this.originAccessIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "OriginAccessIdentity": {
                return Optional.ofNullable(clazz.cast(this.originAccessIdentity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Origin, T> g) {
        return obj -> g.apply((S3Origin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String originAccessIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Origin model) {
            this.domainName(model.domainName);
            this.originAccessIdentity(model.originAccessIdentity);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOriginAccessIdentity() {
            return this.originAccessIdentity;
        }

        @Override
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        public S3Origin build() {
            return new S3Origin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Origin> {
        public Builder domainName(String var1);

        public Builder originAccessIdentity(String var1);
    }
}

