/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.model.CacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.CachedMethods;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;
import software.amazon.awssdk.services.cloudfront.model.CookiePreference;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.model.GeoRestriction;
import software.amazon.awssdk.services.cloudfront.model.Headers;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.LoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.Origin;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.QueryStringCacheKeys;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;
import software.amazon.awssdk.services.cloudfront.model.Tag;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;

public class CreateDistributionWithTagsRequestMarshaller
implements Marshaller<Request<CreateDistributionWithTagsRequest>, CreateDistributionWithTagsRequest> {
    public Request<CreateDistributionWithTagsRequest> marshall(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        if (createDistributionWithTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createDistributionWithTagsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-03-25/distribution?WithTags";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            DistributionConfigWithTags distributionConfigWithTags = createDistributionWithTagsRequest.distributionConfigWithTags();
            if (distributionConfigWithTags != null) {
                Tags tags;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("DistributionConfigWithTags");
                DistributionConfig distributionConfig = distributionConfigWithTags.distributionConfig();
                if (distributionConfig != null) {
                    Restrictions restrictions;
                    ViewerCertificate viewerCertificate;
                    LoggingConfig logging;
                    CustomErrorResponses customErrorResponses;
                    CacheBehaviors cacheBehaviors;
                    DefaultCacheBehavior defaultCacheBehavior;
                    Origins origins;
                    Aliases aliases;
                    xmlWriter.startElement("DistributionConfig");
                    if (distributionConfig.callerReference() != null) {
                        xmlWriter.startElement("CallerReference").value(distributionConfig.callerReference()).endElement();
                    }
                    if ((aliases = distributionConfig.aliases()) != null) {
                        List<String> aliasesItemsList;
                        xmlWriter.startElement("Aliases");
                        if (aliases.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)aliases.quantity()).endElement();
                        }
                        if ((aliasesItemsList = aliases.items()) != null) {
                            xmlWriter.startElement("Items");
                            for (String string : aliasesItemsList) {
                                xmlWriter.startElement("CNAME");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.defaultRootObject() != null) {
                        xmlWriter.startElement("DefaultRootObject").value(distributionConfig.defaultRootObject()).endElement();
                    }
                    if ((origins = distributionConfig.origins()) != null) {
                        List<Origin> originsItemsList;
                        xmlWriter.startElement("Origins");
                        if (origins.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)origins.quantity()).endElement();
                        }
                        if ((originsItemsList = origins.items()) != null) {
                            xmlWriter.startElement("Items");
                            for (Origin originsItemsListValue : originsItemsList) {
                                CustomOriginConfig customOriginConfig;
                                S3OriginConfig s3OriginConfig;
                                CustomHeaders customHeaders;
                                xmlWriter.startElement("Origin");
                                if (originsItemsListValue.id() != null) {
                                    xmlWriter.startElement("Id").value(originsItemsListValue.id()).endElement();
                                }
                                if (originsItemsListValue.domainName() != null) {
                                    xmlWriter.startElement("DomainName").value(originsItemsListValue.domainName()).endElement();
                                }
                                if (originsItemsListValue.originPath() != null) {
                                    xmlWriter.startElement("OriginPath").value(originsItemsListValue.originPath()).endElement();
                                }
                                if ((customHeaders = originsItemsListValue.customHeaders()) != null) {
                                    List<OriginCustomHeader> list;
                                    xmlWriter.startElement("CustomHeaders");
                                    if (customHeaders.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)customHeaders.quantity()).endElement();
                                    }
                                    if ((list = customHeaders.items()) != null) {
                                        xmlWriter.startElement("Items");
                                        for (OriginCustomHeader originCustomHeader : list) {
                                            xmlWriter.startElement("OriginCustomHeader");
                                            if (originCustomHeader.headerName() != null) {
                                                xmlWriter.startElement("HeaderName").value(originCustomHeader.headerName()).endElement();
                                            }
                                            if (originCustomHeader.headerValue() != null) {
                                                xmlWriter.startElement("HeaderValue").value(originCustomHeader.headerValue()).endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((s3OriginConfig = originsItemsListValue.s3OriginConfig()) != null) {
                                    xmlWriter.startElement("S3OriginConfig");
                                    if (s3OriginConfig.originAccessIdentity() != null) {
                                        xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfig.originAccessIdentity()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((customOriginConfig = originsItemsListValue.customOriginConfig()) != null) {
                                    OriginSslProtocols originSslProtocols;
                                    xmlWriter.startElement("CustomOriginConfig");
                                    if (customOriginConfig.httpPort() != null) {
                                        xmlWriter.startElement("HTTPPort").value((Object)customOriginConfig.httpPort()).endElement();
                                    }
                                    if (customOriginConfig.httpsPort() != null) {
                                        xmlWriter.startElement("HTTPSPort").value((Object)customOriginConfig.httpsPort()).endElement();
                                    }
                                    if (customOriginConfig.originProtocolPolicyString() != null) {
                                        xmlWriter.startElement("OriginProtocolPolicy").value(customOriginConfig.originProtocolPolicyString()).endElement();
                                    }
                                    if ((originSslProtocols = customOriginConfig.originSslProtocols()) != null) {
                                        List<String> list;
                                        xmlWriter.startElement("OriginSslProtocols");
                                        if (originSslProtocols.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)originSslProtocols.quantity()).endElement();
                                        }
                                        if ((list = originSslProtocols.itemsStrings()) != null) {
                                            xmlWriter.startElement("Items");
                                            for (String string : list) {
                                                xmlWriter.startElement("SslProtocol");
                                                xmlWriter.value(string);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if (customOriginConfig.originReadTimeout() != null) {
                                        xmlWriter.startElement("OriginReadTimeout").value((Object)customOriginConfig.originReadTimeout()).endElement();
                                    }
                                    if (customOriginConfig.originKeepaliveTimeout() != null) {
                                        xmlWriter.startElement("OriginKeepaliveTimeout").value((Object)customOriginConfig.originKeepaliveTimeout()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((defaultCacheBehavior = distributionConfig.defaultCacheBehavior()) != null) {
                        LambdaFunctionAssociations lambdaFunctionAssociations;
                        Object allowedMethods;
                        TrustedSigners trustedSigners;
                        ForwardedValues forwardedValues;
                        xmlWriter.startElement("DefaultCacheBehavior");
                        if (defaultCacheBehavior.targetOriginId() != null) {
                            xmlWriter.startElement("TargetOriginId").value(defaultCacheBehavior.targetOriginId()).endElement();
                        }
                        if ((forwardedValues = defaultCacheBehavior.forwardedValues()) != null) {
                            QueryStringCacheKeys queryStringCacheKeys;
                            Headers headers;
                            CookiePreference cookies;
                            xmlWriter.startElement("ForwardedValues");
                            if (forwardedValues.queryString() != null) {
                                xmlWriter.startElement("QueryString").value((Object)forwardedValues.queryString()).endElement();
                            }
                            if ((cookies = forwardedValues.cookies()) != null) {
                                CookieNames whitelistedNames;
                                xmlWriter.startElement("Cookies");
                                if (cookies.forwardString() != null) {
                                    xmlWriter.startElement("Forward").value(cookies.forwardString()).endElement();
                                }
                                if ((whitelistedNames = cookies.whitelistedNames()) != null) {
                                    List<String> list;
                                    xmlWriter.startElement("WhitelistedNames");
                                    if (whitelistedNames.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)whitelistedNames.quantity()).endElement();
                                    }
                                    if ((list = whitelistedNames.items()) != null) {
                                        xmlWriter.startElement("Items");
                                        for (String string : list) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(string);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((headers = forwardedValues.headers()) != null) {
                                List<String> list;
                                xmlWriter.startElement("Headers");
                                if (headers.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)headers.quantity()).endElement();
                                }
                                if ((list = headers.items()) != null) {
                                    xmlWriter.startElement("Items");
                                    for (String string : list) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(string);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((queryStringCacheKeys = forwardedValues.queryStringCacheKeys()) != null) {
                                List<String> list;
                                xmlWriter.startElement("QueryStringCacheKeys");
                                if (queryStringCacheKeys.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)queryStringCacheKeys.quantity()).endElement();
                                }
                                if ((list = queryStringCacheKeys.items()) != null) {
                                    xmlWriter.startElement("Items");
                                    for (String string : list) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(string);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((trustedSigners = defaultCacheBehavior.trustedSigners()) != null) {
                            List<String> trustedSignersItemsList;
                            xmlWriter.startElement("TrustedSigners");
                            if (trustedSigners.enabled() != null) {
                                xmlWriter.startElement("Enabled").value((Object)trustedSigners.enabled()).endElement();
                            }
                            if (trustedSigners.quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)trustedSigners.quantity()).endElement();
                            }
                            if ((trustedSignersItemsList = trustedSigners.items()) != null) {
                                xmlWriter.startElement("Items");
                                for (String string : trustedSignersItemsList) {
                                    xmlWriter.startElement("AwsAccountNumber");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (defaultCacheBehavior.viewerProtocolPolicyString() != null) {
                            xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehavior.viewerProtocolPolicyString()).endElement();
                        }
                        if (defaultCacheBehavior.minTTL() != null) {
                            xmlWriter.startElement("MinTTL").value((Object)defaultCacheBehavior.minTTL()).endElement();
                        }
                        if ((allowedMethods = defaultCacheBehavior.allowedMethods()) != null) {
                            CachedMethods cachedMethods;
                            List<String> list;
                            xmlWriter.startElement("AllowedMethods");
                            if (((AllowedMethods)allowedMethods).quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)((AllowedMethods)allowedMethods).quantity()).endElement();
                            }
                            if ((list = ((AllowedMethods)allowedMethods).itemsStrings()) != null) {
                                xmlWriter.startElement("Items");
                                for (String string : list) {
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((cachedMethods = ((AllowedMethods)allowedMethods).cachedMethods()) != null) {
                                List<String> list2;
                                xmlWriter.startElement("CachedMethods");
                                if (cachedMethods.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)cachedMethods.quantity()).endElement();
                                }
                                if ((list2 = cachedMethods.itemsStrings()) != null) {
                                    xmlWriter.startElement("Items");
                                    for (String cachedMethodsItemsListValue : list2) {
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(cachedMethodsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (defaultCacheBehavior.smoothStreaming() != null) {
                            xmlWriter.startElement("SmoothStreaming").value((Object)defaultCacheBehavior.smoothStreaming()).endElement();
                        }
                        if (defaultCacheBehavior.defaultTTL() != null) {
                            xmlWriter.startElement("DefaultTTL").value((Object)defaultCacheBehavior.defaultTTL()).endElement();
                        }
                        if (defaultCacheBehavior.maxTTL() != null) {
                            xmlWriter.startElement("MaxTTL").value((Object)defaultCacheBehavior.maxTTL()).endElement();
                        }
                        if (defaultCacheBehavior.compress() != null) {
                            xmlWriter.startElement("Compress").value((Object)defaultCacheBehavior.compress()).endElement();
                        }
                        if ((lambdaFunctionAssociations = defaultCacheBehavior.lambdaFunctionAssociations()) != null) {
                            List<LambdaFunctionAssociation> list;
                            xmlWriter.startElement("LambdaFunctionAssociations");
                            if (lambdaFunctionAssociations.quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)lambdaFunctionAssociations.quantity()).endElement();
                            }
                            if ((list = lambdaFunctionAssociations.items()) != null) {
                                xmlWriter.startElement("Items");
                                for (LambdaFunctionAssociation lambdaFunctionAssociation : list) {
                                    xmlWriter.startElement("LambdaFunctionAssociation");
                                    if (lambdaFunctionAssociation.lambdaFunctionARN() != null) {
                                        xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociation.lambdaFunctionARN()).endElement();
                                    }
                                    if (lambdaFunctionAssociation.eventTypeString() != null) {
                                        xmlWriter.startElement("EventType").value(lambdaFunctionAssociation.eventTypeString()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((cacheBehaviors = distributionConfig.cacheBehaviors()) != null) {
                        List<CacheBehavior> cacheBehaviorsItemsList;
                        xmlWriter.startElement("CacheBehaviors");
                        if (cacheBehaviors.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)cacheBehaviors.quantity()).endElement();
                        }
                        if ((cacheBehaviorsItemsList = cacheBehaviors.items()) != null) {
                            xmlWriter.startElement("Items");
                            for (CacheBehavior cacheBehavior : cacheBehaviorsItemsList) {
                                LambdaFunctionAssociations lambdaFunctionAssociations;
                                AllowedMethods allowedMethods;
                                TrustedSigners trustedSigners;
                                Object queryStringCacheKeys;
                                ForwardedValues forwardedValues;
                                xmlWriter.startElement("CacheBehavior");
                                if (cacheBehavior.pathPattern() != null) {
                                    xmlWriter.startElement("PathPattern").value(cacheBehavior.pathPattern()).endElement();
                                }
                                if (cacheBehavior.targetOriginId() != null) {
                                    xmlWriter.startElement("TargetOriginId").value(cacheBehavior.targetOriginId()).endElement();
                                }
                                if ((forwardedValues = cacheBehavior.forwardedValues()) != null) {
                                    Headers headers;
                                    CookiePreference cookiePreference;
                                    xmlWriter.startElement("ForwardedValues");
                                    if (forwardedValues.queryString() != null) {
                                        xmlWriter.startElement("QueryString").value((Object)forwardedValues.queryString()).endElement();
                                    }
                                    if ((cookiePreference = forwardedValues.cookies()) != null) {
                                        CookieNames cookieNames;
                                        xmlWriter.startElement("Cookies");
                                        if (cookiePreference.forwardString() != null) {
                                            xmlWriter.startElement("Forward").value(cookiePreference.forwardString()).endElement();
                                        }
                                        if ((cookieNames = cookiePreference.whitelistedNames()) != null) {
                                            List<String> cookieNamesItemsList;
                                            xmlWriter.startElement("WhitelistedNames");
                                            if (cookieNames.quantity() != null) {
                                                xmlWriter.startElement("Quantity").value((Object)cookieNames.quantity()).endElement();
                                            }
                                            if ((cookieNamesItemsList = cookieNames.items()) != null) {
                                                xmlWriter.startElement("Items");
                                                for (String string : cookieNamesItemsList) {
                                                    xmlWriter.startElement("Name");
                                                    xmlWriter.value(string);
                                                    xmlWriter.endElement();
                                                }
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if ((headers = forwardedValues.headers()) != null) {
                                        List<String> headersItemsList;
                                        xmlWriter.startElement("Headers");
                                        if (headers.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)headers.quantity()).endElement();
                                        }
                                        if ((headersItemsList = headers.items()) != null) {
                                            xmlWriter.startElement("Items");
                                            for (String string : headersItemsList) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value(string);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if ((queryStringCacheKeys = forwardedValues.queryStringCacheKeys()) != null) {
                                        List<String> list;
                                        xmlWriter.startElement("QueryStringCacheKeys");
                                        if (((QueryStringCacheKeys)queryStringCacheKeys).quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)((QueryStringCacheKeys)queryStringCacheKeys).quantity()).endElement();
                                        }
                                        if ((list = ((QueryStringCacheKeys)queryStringCacheKeys).items()) != null) {
                                            xmlWriter.startElement("Items");
                                            for (Object queryStringCacheKeysItemsListValue : list) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value((String)queryStringCacheKeysItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((trustedSigners = cacheBehavior.trustedSigners()) != null) {
                                    List<String> list;
                                    xmlWriter.startElement("TrustedSigners");
                                    if (trustedSigners.enabled() != null) {
                                        xmlWriter.startElement("Enabled").value((Object)trustedSigners.enabled()).endElement();
                                    }
                                    if (trustedSigners.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)trustedSigners.quantity()).endElement();
                                    }
                                    if ((list = trustedSigners.items()) != null) {
                                        xmlWriter.startElement("Items");
                                        queryStringCacheKeys = list.iterator();
                                        while (queryStringCacheKeys.hasNext()) {
                                            String string = (String)queryStringCacheKeys.next();
                                            xmlWriter.startElement("AwsAccountNumber");
                                            xmlWriter.value(string);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (cacheBehavior.viewerProtocolPolicyString() != null) {
                                    xmlWriter.startElement("ViewerProtocolPolicy").value(cacheBehavior.viewerProtocolPolicyString()).endElement();
                                }
                                if (cacheBehavior.minTTL() != null) {
                                    xmlWriter.startElement("MinTTL").value((Object)cacheBehavior.minTTL()).endElement();
                                }
                                if ((allowedMethods = cacheBehavior.allowedMethods()) != null) {
                                    CachedMethods cachedMethods;
                                    List<String> allowedMethodsItemsList;
                                    xmlWriter.startElement("AllowedMethods");
                                    if (allowedMethods.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)allowedMethods.quantity()).endElement();
                                    }
                                    if ((allowedMethodsItemsList = allowedMethods.itemsStrings()) != null) {
                                        xmlWriter.startElement("Items");
                                        for (String string : allowedMethodsItemsList) {
                                            xmlWriter.startElement("Method");
                                            xmlWriter.value(string);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if ((cachedMethods = allowedMethods.cachedMethods()) != null) {
                                        List<String> list;
                                        xmlWriter.startElement("CachedMethods");
                                        if (cachedMethods.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)cachedMethods.quantity()).endElement();
                                        }
                                        if ((list = cachedMethods.itemsStrings()) != null) {
                                            Object queryStringCacheKeysItemsListValue;
                                            xmlWriter.startElement("Items");
                                            queryStringCacheKeysItemsListValue = list.iterator();
                                            while (queryStringCacheKeysItemsListValue.hasNext()) {
                                                String cachedMethodsItemsListValue = (String)queryStringCacheKeysItemsListValue.next();
                                                xmlWriter.startElement("Method");
                                                xmlWriter.value(cachedMethodsItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (cacheBehavior.smoothStreaming() != null) {
                                    xmlWriter.startElement("SmoothStreaming").value((Object)cacheBehavior.smoothStreaming()).endElement();
                                }
                                if (cacheBehavior.defaultTTL() != null) {
                                    xmlWriter.startElement("DefaultTTL").value((Object)cacheBehavior.defaultTTL()).endElement();
                                }
                                if (cacheBehavior.maxTTL() != null) {
                                    xmlWriter.startElement("MaxTTL").value((Object)cacheBehavior.maxTTL()).endElement();
                                }
                                if (cacheBehavior.compress() != null) {
                                    xmlWriter.startElement("Compress").value((Object)cacheBehavior.compress()).endElement();
                                }
                                if ((lambdaFunctionAssociations = cacheBehavior.lambdaFunctionAssociations()) != null) {
                                    List<LambdaFunctionAssociation> list;
                                    xmlWriter.startElement("LambdaFunctionAssociations");
                                    if (lambdaFunctionAssociations.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)lambdaFunctionAssociations.quantity()).endElement();
                                    }
                                    if ((list = lambdaFunctionAssociations.items()) != null) {
                                        xmlWriter.startElement("Items");
                                        for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : list) {
                                            xmlWriter.startElement("LambdaFunctionAssociation");
                                            if (lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN() != null) {
                                                xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN()).endElement();
                                            }
                                            if (lambdaFunctionAssociationsItemsListValue.eventTypeString() != null) {
                                                xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.eventTypeString()).endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((customErrorResponses = distributionConfig.customErrorResponses()) != null) {
                        List<CustomErrorResponse> customErrorResponsesItemsList;
                        xmlWriter.startElement("CustomErrorResponses");
                        if (customErrorResponses.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)customErrorResponses.quantity()).endElement();
                        }
                        if ((customErrorResponsesItemsList = customErrorResponses.items()) != null) {
                            xmlWriter.startElement("Items");
                            for (CustomErrorResponse customErrorResponse : customErrorResponsesItemsList) {
                                xmlWriter.startElement("CustomErrorResponse");
                                if (customErrorResponse.errorCode() != null) {
                                    xmlWriter.startElement("ErrorCode").value((Object)customErrorResponse.errorCode()).endElement();
                                }
                                if (customErrorResponse.responsePagePath() != null) {
                                    xmlWriter.startElement("ResponsePagePath").value(customErrorResponse.responsePagePath()).endElement();
                                }
                                if (customErrorResponse.responseCode() != null) {
                                    xmlWriter.startElement("ResponseCode").value(customErrorResponse.responseCode()).endElement();
                                }
                                if (customErrorResponse.errorCachingMinTTL() != null) {
                                    xmlWriter.startElement("ErrorCachingMinTTL").value((Object)customErrorResponse.errorCachingMinTTL()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.comment() != null) {
                        xmlWriter.startElement("Comment").value(distributionConfig.comment()).endElement();
                    }
                    if ((logging = distributionConfig.logging()) != null) {
                        xmlWriter.startElement("Logging");
                        if (logging.enabled() != null) {
                            xmlWriter.startElement("Enabled").value((Object)logging.enabled()).endElement();
                        }
                        if (logging.includeCookies() != null) {
                            xmlWriter.startElement("IncludeCookies").value((Object)logging.includeCookies()).endElement();
                        }
                        if (logging.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                        }
                        if (logging.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.priceClassString() != null) {
                        xmlWriter.startElement("PriceClass").value(distributionConfig.priceClassString()).endElement();
                    }
                    if (distributionConfig.enabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)distributionConfig.enabled()).endElement();
                    }
                    if ((viewerCertificate = distributionConfig.viewerCertificate()) != null) {
                        xmlWriter.startElement("ViewerCertificate");
                        if (viewerCertificate.cloudFrontDefaultCertificate() != null) {
                            xmlWriter.startElement("CloudFrontDefaultCertificate").value((Object)viewerCertificate.cloudFrontDefaultCertificate()).endElement();
                        }
                        if (viewerCertificate.iamCertificateId() != null) {
                            xmlWriter.startElement("IAMCertificateId").value(viewerCertificate.iamCertificateId()).endElement();
                        }
                        if (viewerCertificate.acmCertificateArn() != null) {
                            xmlWriter.startElement("ACMCertificateArn").value(viewerCertificate.acmCertificateArn()).endElement();
                        }
                        if (viewerCertificate.sslSupportMethodString() != null) {
                            xmlWriter.startElement("SSLSupportMethod").value(viewerCertificate.sslSupportMethodString()).endElement();
                        }
                        if (viewerCertificate.minimumProtocolVersionString() != null) {
                            xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificate.minimumProtocolVersionString()).endElement();
                        }
                        if (viewerCertificate.certificate() != null) {
                            xmlWriter.startElement("Certificate").value(viewerCertificate.certificate()).endElement();
                        }
                        if (viewerCertificate.certificateSourceString() != null) {
                            xmlWriter.startElement("CertificateSource").value(viewerCertificate.certificateSourceString()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((restrictions = distributionConfig.restrictions()) != null) {
                        xmlWriter.startElement("Restrictions");
                        GeoRestriction geoRestriction = restrictions.geoRestriction();
                        if (geoRestriction != null) {
                            List<String> list;
                            xmlWriter.startElement("GeoRestriction");
                            if (geoRestriction.restrictionTypeString() != null) {
                                xmlWriter.startElement("RestrictionType").value(geoRestriction.restrictionTypeString()).endElement();
                            }
                            if (geoRestriction.quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)geoRestriction.quantity()).endElement();
                            }
                            if ((list = geoRestriction.items()) != null) {
                                xmlWriter.startElement("Items");
                                for (String string : list) {
                                    xmlWriter.startElement("Location");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.webACLId() != null) {
                        xmlWriter.startElement("WebACLId").value(distributionConfig.webACLId()).endElement();
                    }
                    if (distributionConfig.httpVersionString() != null) {
                        xmlWriter.startElement("HttpVersion").value(distributionConfig.httpVersionString()).endElement();
                    }
                    if (distributionConfig.isIPV6Enabled() != null) {
                        xmlWriter.startElement("IsIPV6Enabled").value((Object)distributionConfig.isIPV6Enabled()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((tags = distributionConfigWithTags.tags()) != null) {
                    xmlWriter.startElement("Tags");
                    List<Tag> tagsItemsList = tags.items();
                    if (tagsItemsList != null) {
                        xmlWriter.startElement("Items");
                        for (Tag tag : tagsItemsList) {
                            xmlWriter.startElement("Tag");
                            if (tag.key() != null) {
                                xmlWriter.startElement("Key").value(tag.key()).endElement();
                            }
                            if (tag.value() != null) {
                                xmlWriter.startElement("Value").value(tag.value()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

