/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistribution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateStreamingDistributionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, CreateStreamingDistributionResponse> {
    private final StreamingDistribution streamingDistribution;
    private final String location;
    private final String eTag;

    private CreateStreamingDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistribution = builder.streamingDistribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    public StreamingDistribution streamingDistribution() {
        return this.streamingDistribution;
    }

    public String location() {
        return this.location;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionResponse)) {
            return false;
        }
        CreateStreamingDistributionResponse other = (CreateStreamingDistributionResponse)((Object)obj);
        return Objects.equals(this.streamingDistribution(), other.streamingDistribution()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"CreateStreamingDistributionResponse").add("StreamingDistribution", (Object)this.streamingDistribution()).add("Location", (Object)this.location()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistribution": {
                return Optional.of(clazz.cast(this.streamingDistribution()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private StreamingDistribution streamingDistribution;
        private String location;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionResponse model) {
            this.streamingDistribution(model.streamingDistribution);
            this.location(model.location);
            this.eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return this.streamingDistribution != null ? this.streamingDistribution.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateStreamingDistributionResponse build() {
            return new CreateStreamingDistributionResponse(this);
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    CopyableBuilder<Builder, CreateStreamingDistributionResponse> {
        public Builder streamingDistribution(StreamingDistribution var1);

        default public Builder streamingDistribution(Consumer<StreamingDistribution.Builder> streamingDistribution) {
            return this.streamingDistribution((StreamingDistribution)((StreamingDistribution.Builder)StreamingDistribution.builder().apply(streamingDistribution)).build());
        }

        public Builder location(String var1);

        public Builder eTag(String var1);
    }
}

