/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateCloudFrontOriginAccessIdentityRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityRequest> {
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;
    private final String id;
    private final String ifMatch;

    private UpdateCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return this.cloudFrontOriginAccessIdentityConfig;
    }

    public String id() {
        return this.id;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        UpdateCloudFrontOriginAccessIdentityRequest other = (UpdateCloudFrontOriginAccessIdentityRequest)((Object)obj);
        return Objects.equals(this.cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cloudFrontOriginAccessIdentityConfig() != null) {
            sb.append("CloudFrontOriginAccessIdentityConfig: ").append(this.cloudFrontOriginAccessIdentityConfig()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.ifMatch() != null) {
            sb.append("IfMatch: ").append(this.ifMatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontOriginAccessIdentityConfig": {
                return Optional.of(clazz.cast(this.cloudFrontOriginAccessIdentityConfig()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.of(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCloudFrontOriginAccessIdentityRequest model) {
            this.cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig != null ? this.cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateCloudFrontOriginAccessIdentityRequest build() {
            return new UpdateCloudFrontOriginAccessIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    CopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityRequest> {
        public Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig var1);

        default public Builder cloudFrontOriginAccessIdentityConfig(Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return this.cloudFrontOriginAccessIdentityConfig((CloudFrontOriginAccessIdentityConfig)((CloudFrontOriginAccessIdentityConfig.Builder)CloudFrontOriginAccessIdentityConfig.builder().apply(cloudFrontOriginAccessIdentityConfig)).build());
        }

        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

