/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebACLIdRequest;

public class ListDistributionsByWebACLIdRequestMarshaller
implements Marshaller<Request<ListDistributionsByWebACLIdRequest>, ListDistributionsByWebACLIdRequest> {
    public Request<ListDistributionsByWebACLIdRequest> marshall(ListDistributionsByWebACLIdRequest listDistributionsByWebACLIdRequest) {
        if (listDistributionsByWebACLIdRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDistributionsByWebACLIdRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distributionsByWebACLId/{WebACLId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "WebACLId", listDistributionsByWebACLIdRequest.webACLId());
        request.setResourcePath(uriResourcePath);
        if (listDistributionsByWebACLIdRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listDistributionsByWebACLIdRequest.marker()));
        }
        if (listDistributionsByWebACLIdRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString((String)listDistributionsByWebACLIdRequest.maxItems()));
        }
        return request;
    }
}

