/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Distribution;
import software.amazon.awssdk.services.cloudfront.transform.ActiveTrustedSignersUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DistributionConfigUnmarshaller;

public class DistributionUnmarshaller
implements Unmarshaller<Distribution, StaxUnmarshallerContext> {
    private static final DistributionUnmarshaller INSTANCE = new DistributionUnmarshaller();

    public Distribution unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Distribution.Builder distribution = Distribution.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    distribution.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ARN", targetDepth)) {
                    distribution.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    distribution.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    distribution.lastModifiedTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InProgressInvalidationBatches", targetDepth)) {
                    distribution.inProgressInvalidationBatches(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainName", targetDepth)) {
                    distribution.domainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ActiveTrustedSigners", targetDepth)) {
                    distribution.activeTrustedSigners(ActiveTrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DistributionConfig", targetDepth)) continue;
                distribution.distributionConfig(DistributionConfigUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Distribution)distribution.build();
    }

    public static DistributionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

