/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudfront.model.Distribution;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDistributionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UpdateDistributionResponse> {
    private final Distribution distribution;
    private final String eTag;

    private UpdateDistributionResponse(BuilderImpl builder) {
        this.distribution = builder.distribution;
        this.eTag = builder.eTag;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.distribution() == null ? 0 : this.distribution().hashCode());
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionResponse)) {
            return false;
        }
        UpdateDistributionResponse other = (UpdateDistributionResponse)((Object)obj);
        if (other.distribution() == null ^ this.distribution() == null) {
            return false;
        }
        if (other.distribution() != null && !other.distribution().equals(this.distribution())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        return other.eTag() == null || other.eTag().equals(this.eTag());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.distribution() != null) {
            sb.append("Distribution: ").append(this.distribution()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distribution": {
                return Optional.of(clazz.cast(this.distribution()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Distribution distribution;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionResponse model) {
            this.distribution(model.distribution);
            this.eTag(model.eTag);
        }

        public final Distribution.Builder getDistribution() {
            return this.distribution != null ? this.distribution.toBuilder() : null;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public UpdateDistributionResponse build() {
            return new UpdateDistributionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDistributionResponse> {
        public Builder distribution(Distribution var1);

        public Builder eTag(String var1);
    }
}

