/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudfront.model.SslProtocol;
import software.amazon.awssdk.services.cloudfront.model.SslProtocolsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OriginSslProtocols
implements ToCopyableBuilder<Builder, OriginSslProtocols> {
    private final Integer quantity;
    private final List<String> items;

    private OriginSslProtocols(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<SslProtocol> items() {
        return TypeConverter.convert(this.items, SslProtocol::fromValue);
    }

    public List<String> itemsStrings() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.itemsStrings() == null ? 0 : this.itemsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginSslProtocols)) {
            return false;
        }
        OriginSslProtocols other = (OriginSslProtocols)obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.itemsStrings() == null ^ this.itemsStrings() == null) {
            return false;
        }
        return other.itemsStrings() == null || other.itemsStrings().equals(this.itemsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.itemsStrings() != null) {
            sb.append("Items: ").append(this.itemsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.itemsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<String> items;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginSslProtocols model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = SslProtocolsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = SslProtocolsListCopier.copy(items);
        }

        public OriginSslProtocols build() {
            return new OriginSslProtocols(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OriginSslProtocols> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);
    }
}

