/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType;
import software.amazon.awssdk.services.cloudfront.model.LocationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GeoRestriction
implements ToCopyableBuilder<Builder, GeoRestriction> {
    private final String restrictionType;
    private final Integer quantity;
    private final List<String> items;

    private GeoRestriction(BuilderImpl builder) {
        this.restrictionType = builder.restrictionType;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public GeoRestrictionType restrictionType() {
        return GeoRestrictionType.fromValue(this.restrictionType);
    }

    public String restrictionTypeString() {
        return this.restrictionType;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<String> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.restrictionTypeString() == null ? 0 : this.restrictionTypeString().hashCode());
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoRestriction)) {
            return false;
        }
        GeoRestriction other = (GeoRestriction)obj;
        if (other.restrictionTypeString() == null ^ this.restrictionTypeString() == null) {
            return false;
        }
        if (other.restrictionTypeString() != null && !other.restrictionTypeString().equals(this.restrictionTypeString())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.restrictionTypeString() != null) {
            sb.append("RestrictionType: ").append(this.restrictionTypeString()).append(",");
        }
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestrictionType": {
                return Optional.of(clazz.cast(this.restrictionTypeString()));
            }
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String restrictionType;
        private Integer quantity;
        private List<String> items;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoRestriction model) {
            this.restrictionType(model.restrictionType);
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final String getRestrictionType() {
            return this.restrictionType;
        }

        @Override
        public final Builder restrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
            return this;
        }

        @Override
        public final Builder restrictionType(GeoRestrictionType restrictionType) {
            this.restrictionType(restrictionType.toString());
            return this;
        }

        public final void setRestrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = LocationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = LocationListCopier.copy(items);
        }

        public GeoRestriction build() {
            return new GeoRestriction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GeoRestriction> {
        public Builder restrictionType(String var1);

        public Builder restrictionType(GeoRestrictionType var1);

        public Builder quantity(Integer var1);

        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);
    }
}

