/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;
import software.amazon.awssdk.services.cloudfront.model.ItemSelection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CookiePreference
implements ToCopyableBuilder<Builder, CookiePreference> {
    private final String forward;
    private final CookieNames whitelistedNames;

    private CookiePreference(BuilderImpl builder) {
        this.forward = builder.forward;
        this.whitelistedNames = builder.whitelistedNames;
    }

    public ItemSelection forward() {
        return ItemSelection.fromValue(this.forward);
    }

    public String forwardString() {
        return this.forward;
    }

    public CookieNames whitelistedNames() {
        return this.whitelistedNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.forwardString() == null ? 0 : this.forwardString().hashCode());
        hashCode = 31 * hashCode + (this.whitelistedNames() == null ? 0 : this.whitelistedNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookiePreference)) {
            return false;
        }
        CookiePreference other = (CookiePreference)obj;
        if (other.forwardString() == null ^ this.forwardString() == null) {
            return false;
        }
        if (other.forwardString() != null && !other.forwardString().equals(this.forwardString())) {
            return false;
        }
        if (other.whitelistedNames() == null ^ this.whitelistedNames() == null) {
            return false;
        }
        return other.whitelistedNames() == null || other.whitelistedNames().equals(this.whitelistedNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.forwardString() != null) {
            sb.append("Forward: ").append(this.forwardString()).append(",");
        }
        if (this.whitelistedNames() != null) {
            sb.append("WhitelistedNames: ").append(this.whitelistedNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Forward": {
                return Optional.of(clazz.cast(this.forwardString()));
            }
            case "WhitelistedNames": {
                return Optional.of(clazz.cast(this.whitelistedNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String forward;
        private CookieNames whitelistedNames;

        private BuilderImpl() {
        }

        private BuilderImpl(CookiePreference model) {
            this.forward(model.forward);
            this.whitelistedNames(model.whitelistedNames);
        }

        public final String getForward() {
            return this.forward;
        }

        @Override
        public final Builder forward(String forward) {
            this.forward = forward;
            return this;
        }

        @Override
        public final Builder forward(ItemSelection forward) {
            this.forward(forward.toString());
            return this;
        }

        public final void setForward(String forward) {
            this.forward = forward;
        }

        public final CookieNames.Builder getWhitelistedNames() {
            return this.whitelistedNames != null ? this.whitelistedNames.toBuilder() : null;
        }

        @Override
        public final Builder whitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
            return this;
        }

        public final void setWhitelistedNames(CookieNames.BuilderImpl whitelistedNames) {
            this.whitelistedNames = whitelistedNames != null ? whitelistedNames.build() : null;
        }

        public CookiePreference build() {
            return new CookiePreference(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CookiePreference> {
        public Builder forward(String var1);

        public Builder forward(ItemSelection var1);

        public Builder whitelistedNames(CookieNames var1);
    }
}

