/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.TagKeys;

public class TagKeysUnmarshaller
implements Unmarshaller<TagKeys, StaxUnmarshallerContext> {
    private static TagKeysUnmarshaller INSTANCE;

    public TagKeys unmarshall(StaxUnmarshallerContext context) throws Exception {
        TagKeys.Builder tagKeys;
        block5: {
            tagKeys = TagKeys.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    tagKeys.items(items);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("Items/Key", targetDepth)) continue;
                    items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            tagKeys.items(items);
        }
        return (TagKeys)tagKeys.build();
    }

    public static TagKeysUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagKeysUnmarshaller();
        }
        return INSTANCE;
    }
}

