/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionList;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary;
import software.amazon.awssdk.services.cloudfront.transform.StreamingDistributionSummaryUnmarshaller;

public class StreamingDistributionListUnmarshaller
implements Unmarshaller<StreamingDistributionList, StaxUnmarshallerContext> {
    private static final StreamingDistributionListUnmarshaller INSTANCE = new StreamingDistributionListUnmarshaller();

    public StreamingDistributionList unmarshall(StaxUnmarshallerContext context) throws Exception {
        StreamingDistributionList.Builder streamingDistributionList;
        block10: {
            streamingDistributionList = StreamingDistributionList.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<StreamingDistributionSummary> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    streamingDistributionList.items(items);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Marker", targetDepth)) {
                        streamingDistributionList.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextMarker", targetDepth)) {
                        streamingDistributionList.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxItems", targetDepth)) {
                        streamingDistributionList.maxItems(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        streamingDistributionList.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Quantity", targetDepth)) {
                        streamingDistributionList.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<StreamingDistributionSummary>();
                        continue;
                    }
                    if (!context.testExpression("Items/StreamingDistributionSummary", targetDepth)) continue;
                    items.add(StreamingDistributionSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            streamingDistributionList.items(items);
        }
        return (StreamingDistributionList)streamingDistributionList.build();
    }

    public static StreamingDistributionListUnmarshaller getInstance() {
        return INSTANCE;
    }
}

