/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;

public class ListDistributionsRequestMarshaller
implements Marshaller<Request<ListDistributionsRequest>, ListDistributionsRequest> {
    public Request<ListDistributionsRequest> marshall(ListDistributionsRequest listDistributionsRequest) {
        if (listDistributionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listDistributionsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distribution";
        request.setResourcePath(uriResourcePath);
        if (listDistributionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listDistributionsRequest.marker()));
        }
        if (listDistributionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromString((String)listDistributionsRequest.maxItems()));
        }
        return request;
    }
}

