/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.Signer;
import software.amazon.awssdk.services.cloudfront.transform.SignerUnmarshaller;

public class ActiveTrustedSignersUnmarshaller
implements Unmarshaller<ActiveTrustedSigners, StaxUnmarshallerContext> {
    private static final ActiveTrustedSignersUnmarshaller INSTANCE = new ActiveTrustedSignersUnmarshaller();

    public ActiveTrustedSigners unmarshall(StaxUnmarshallerContext context) throws Exception {
        ActiveTrustedSigners.Builder activeTrustedSigners;
        block7: {
            activeTrustedSigners = ActiveTrustedSigners.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Signer> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    activeTrustedSigners.items(items);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Enabled", targetDepth)) {
                        activeTrustedSigners.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Quantity", targetDepth)) {
                        activeTrustedSigners.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<Signer>();
                        continue;
                    }
                    if (!context.testExpression("Items/Signer", targetDepth)) continue;
                    items.add(SignerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            activeTrustedSigners.items(items);
        }
        return (ActiveTrustedSigners)activeTrustedSigners.build();
    }

    public static ActiveTrustedSignersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

