/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.KeyPairIds;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Signer
implements ToCopyableBuilder<Builder, Signer> {
    private final String awsAccountNumber;
    private final KeyPairIds keyPairIds;

    private Signer(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.keyPairIds = builder.keyPairIds;
    }

    public String awsAccountNumber() {
        return this.awsAccountNumber;
    }

    public KeyPairIds keyPairIds() {
        return this.keyPairIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signer)) {
            return false;
        }
        Signer other = (Signer)obj;
        return Objects.equals(this.awsAccountNumber(), other.awsAccountNumber()) && Objects.equals(this.keyPairIds(), other.keyPairIds());
    }

    public String toString() {
        return ToString.builder((String)"Signer").add("AwsAccountNumber", (Object)this.awsAccountNumber()).add("KeyPairIds", (Object)this.keyPairIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.awsAccountNumber()));
            }
            case "KeyPairIds": {
                return Optional.ofNullable(clazz.cast(this.keyPairIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountNumber;
        private KeyPairIds keyPairIds;

        private BuilderImpl() {
        }

        private BuilderImpl(Signer model) {
            this.awsAccountNumber(model.awsAccountNumber);
            this.keyPairIds(model.keyPairIds);
        }

        public final String getAwsAccountNumber() {
            return this.awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        public final KeyPairIds.Builder getKeyPairIds() {
            return this.keyPairIds != null ? this.keyPairIds.toBuilder() : null;
        }

        @Override
        public final Builder keyPairIds(KeyPairIds keyPairIds) {
            this.keyPairIds = keyPairIds;
            return this;
        }

        public final void setKeyPairIds(KeyPairIds.BuilderImpl keyPairIds) {
            this.keyPairIds = keyPairIds != null ? keyPairIds.build() : null;
        }

        public Signer build() {
            return new Signer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Signer> {
        public Builder awsAccountNumber(String var1);

        public Builder keyPairIds(KeyPairIds var1);

        default public Builder keyPairIds(Consumer<KeyPairIds.Builder> keyPairIds) {
            return this.keyPairIds((KeyPairIds)((KeyPairIds.Builder)KeyPairIds.builder().applyMutation(keyPairIds)).build());
        }
    }
}

