/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;

public class ListStreamingDistributionsRequestMarshaller
implements Marshaller<Request<ListStreamingDistributionsRequest>, ListStreamingDistributionsRequest> {
    public Request<ListStreamingDistributionsRequest> marshall(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        if (listStreamingDistributionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listStreamingDistributionsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/streaming-distribution";
        request.setResourcePath(uriResourcePath);
        if (listStreamingDistributionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listStreamingDistributionsRequest.marker()));
        }
        if (listStreamingDistributionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromString((String)listStreamingDistributionsRequest.maxItems()));
        }
        return request;
    }
}

