/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.transform.CacheBehaviorUnmarshaller;

public class CacheBehaviorsUnmarshaller
implements Unmarshaller<CacheBehaviors, StaxUnmarshallerContext> {
    private static final CacheBehaviorsUnmarshaller INSTANCE = new CacheBehaviorsUnmarshaller();

    public CacheBehaviors unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheBehaviors.Builder cacheBehaviors;
        block6: {
            cacheBehaviors = CacheBehaviors.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CacheBehavior> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cacheBehaviors.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        cacheBehaviors.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<CacheBehavior>();
                        continue;
                    }
                    if (!context.testExpression("Items/CacheBehavior", targetDepth)) continue;
                    items.add(CacheBehaviorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cacheBehaviors.items(items);
        }
        return (CacheBehaviors)cacheBehaviors.build();
    }

    public static CacheBehaviorsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

