/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.S3Origin;
import software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamingDistributionConfig
implements ToCopyableBuilder<Builder, StreamingDistributionConfig> {
    private final String callerReference;
    private final S3Origin s3Origin;
    private final Aliases aliases;
    private final String comment;
    private final StreamingLoggingConfig logging;
    private final TrustedSigners trustedSigners;
    private final String priceClass;
    private final Boolean enabled;

    private StreamingDistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.trustedSigners = builder.trustedSigners;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public S3Origin s3Origin() {
        return this.s3Origin;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public String comment() {
        return this.comment;
    }

    public StreamingLoggingConfig logging() {
        return this.logging;
    }

    public TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public String priceClassAsString() {
        return this.priceClass;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfig)) {
            return false;
        }
        StreamingDistributionConfig other = (StreamingDistributionConfig)obj;
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.s3Origin(), other.s3Origin()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.trustedSigners(), other.trustedSigners()) && Objects.equals(this.priceClassAsString(), other.priceClassAsString()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"StreamingDistributionConfig").add("CallerReference", (Object)this.callerReference()).add("S3Origin", (Object)this.s3Origin()).add("Aliases", (Object)this.aliases()).add("Comment", (Object)this.comment()).add("Logging", (Object)this.logging()).add("TrustedSigners", (Object)this.trustedSigners()).add("PriceClass", (Object)this.priceClassAsString()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "S3Origin": {
                return Optional.of(clazz.cast(this.s3Origin()));
            }
            case "Aliases": {
                return Optional.of(clazz.cast(this.aliases()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "Logging": {
                return Optional.of(clazz.cast(this.logging()));
            }
            case "TrustedSigners": {
                return Optional.of(clazz.cast(this.trustedSigners()));
            }
            case "PriceClass": {
                return Optional.of(clazz.cast(this.priceClassAsString()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private S3Origin s3Origin;
        private Aliases aliases;
        private String comment;
        private StreamingLoggingConfig logging;
        private TrustedSigners trustedSigners;
        private String priceClass;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfig model) {
            this.callerReference(model.callerReference);
            this.s3Origin(model.s3Origin);
            this.aliases(model.aliases);
            this.comment(model.comment);
            this.logging(model.logging);
            this.trustedSigners(model.trustedSigners);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final S3Origin.Builder getS3Origin() {
            return this.s3Origin != null ? this.s3Origin.toBuilder() : null;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin.BuilderImpl s3Origin) {
            this.s3Origin = s3Origin != null ? s3Origin.build() : null;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final StreamingLoggingConfig.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(StreamingLoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(StreamingLoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return this.trustedSigners != null ? this.trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public StreamingDistributionConfig build() {
            return new StreamingDistributionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamingDistributionConfig> {
        public Builder callerReference(String var1);

        public Builder s3Origin(S3Origin var1);

        default public Builder s3Origin(Consumer<S3Origin.Builder> s3Origin) {
            return this.s3Origin((S3Origin)((S3Origin.Builder)S3Origin.builder().apply(s3Origin)).build());
        }

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().apply(aliases)).build());
        }

        public Builder comment(String var1);

        public Builder logging(StreamingLoggingConfig var1);

        default public Builder logging(Consumer<StreamingLoggingConfig.Builder> logging) {
            return this.logging((StreamingLoggingConfig)((StreamingLoggingConfig.Builder)StreamingLoggingConfig.builder().apply(logging)).build());
        }

        public Builder trustedSigners(TrustedSigners var1);

        default public Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return this.trustedSigners((TrustedSigners)((TrustedSigners.Builder)TrustedSigners.builder().apply(trustedSigners)).build());
        }

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);
    }
}

