/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;

public class OriginSslProtocolsUnmarshaller
implements Unmarshaller<OriginSslProtocols, StaxUnmarshallerContext> {
    private static OriginSslProtocolsUnmarshaller INSTANCE;

    public OriginSslProtocols unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        OriginSslProtocols.Builder originSslProtocols = OriginSslProtocols.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    originSslProtocols.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    originSslProtocols.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/SslProtocol", targetDepth)) continue;
                originSslProtocols.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (OriginSslProtocols)originSslProtocols.build();
    }

    public static OriginSslProtocolsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OriginSslProtocolsUnmarshaller();
        }
        return INSTANCE;
    }
}

