/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.S3Origin;
import software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamingDistributionConfig
implements ToCopyableBuilder<Builder, StreamingDistributionConfig> {
    private final String callerReference;
    private final S3Origin s3Origin;
    private final Aliases aliases;
    private final String comment;
    private final StreamingLoggingConfig logging;
    private final TrustedSigners trustedSigners;
    private final String priceClass;
    private final Boolean enabled;

    private StreamingDistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.trustedSigners = builder.trustedSigners;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public S3Origin s3Origin() {
        return this.s3Origin;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public String comment() {
        return this.comment;
    }

    public StreamingLoggingConfig logging() {
        return this.logging;
    }

    public TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public String priceClass() {
        return this.priceClass;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.s3Origin() == null ? 0 : this.s3Origin().hashCode());
        hashCode = 31 * hashCode + (this.aliases() == null ? 0 : this.aliases().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.logging() == null ? 0 : this.logging().hashCode());
        hashCode = 31 * hashCode + (this.trustedSigners() == null ? 0 : this.trustedSigners().hashCode());
        hashCode = 31 * hashCode + (this.priceClass() == null ? 0 : this.priceClass().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfig)) {
            return false;
        }
        StreamingDistributionConfig other = (StreamingDistributionConfig)obj;
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.s3Origin() == null ^ this.s3Origin() == null) {
            return false;
        }
        if (other.s3Origin() != null && !other.s3Origin().equals(this.s3Origin())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        if (other.aliases() != null && !other.aliases().equals(this.aliases())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.logging() == null ^ this.logging() == null) {
            return false;
        }
        if (other.logging() != null && !other.logging().equals(this.logging())) {
            return false;
        }
        if (other.trustedSigners() == null ^ this.trustedSigners() == null) {
            return false;
        }
        if (other.trustedSigners() != null && !other.trustedSigners().equals(this.trustedSigners())) {
            return false;
        }
        if (other.priceClass() == null ^ this.priceClass() == null) {
            return false;
        }
        if (other.priceClass() != null && !other.priceClass().equals(this.priceClass())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        return other.enabled() == null || other.enabled().equals(this.enabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.s3Origin() != null) {
            sb.append("S3Origin: ").append(this.s3Origin()).append(",");
        }
        if (this.aliases() != null) {
            sb.append("Aliases: ").append(this.aliases()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.logging() != null) {
            sb.append("Logging: ").append(this.logging()).append(",");
        }
        if (this.trustedSigners() != null) {
            sb.append("TrustedSigners: ").append(this.trustedSigners()).append(",");
        }
        if (this.priceClass() != null) {
            sb.append("PriceClass: ").append(this.priceClass()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private S3Origin s3Origin;
        private Aliases aliases;
        private String comment;
        private StreamingLoggingConfig logging;
        private TrustedSigners trustedSigners;
        private String priceClass;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfig model) {
            this.setCallerReference(model.callerReference);
            this.setS3Origin(model.s3Origin);
            this.setAliases(model.aliases);
            this.setComment(model.comment);
            this.setLogging(model.logging);
            this.setTrustedSigners(model.trustedSigners);
            this.setPriceClass(model.priceClass);
            this.setEnabled(model.enabled);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final S3Origin getS3Origin() {
            return this.s3Origin;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
        }

        public final Aliases getAliases() {
            return this.aliases;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases aliases) {
            this.aliases = aliases;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final StreamingLoggingConfig getLogging() {
            return this.logging;
        }

        @Override
        public final Builder logging(StreamingLoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(StreamingLoggingConfig logging) {
            this.logging = logging;
        }

        public final TrustedSigners getTrustedSigners() {
            return this.trustedSigners;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final void setPriceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public StreamingDistributionConfig build() {
            return new StreamingDistributionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamingDistributionConfig> {
        public Builder callerReference(String var1);

        public Builder s3Origin(S3Origin var1);

        public Builder aliases(Aliases var1);

        public Builder comment(String var1);

        public Builder logging(StreamingLoggingConfig var1);

        public Builder trustedSigners(TrustedSigners var1);

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);
    }
}

