/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Origin
implements ToCopyableBuilder<Builder, Origin> {
    private final String id;
    private final String domainName;
    private final String originPath;
    private final CustomHeaders customHeaders;
    private final S3OriginConfig s3OriginConfig;
    private final CustomOriginConfig customOriginConfig;

    private Origin(BuilderImpl builder) {
        this.id = builder.id;
        this.domainName = builder.domainName;
        this.originPath = builder.originPath;
        this.customHeaders = builder.customHeaders;
        this.s3OriginConfig = builder.s3OriginConfig;
        this.customOriginConfig = builder.customOriginConfig;
    }

    public String id() {
        return this.id;
    }

    public String domainName() {
        return this.domainName;
    }

    public String originPath() {
        return this.originPath;
    }

    public CustomHeaders customHeaders() {
        return this.customHeaders;
    }

    public S3OriginConfig s3OriginConfig() {
        return this.s3OriginConfig;
    }

    public CustomOriginConfig customOriginConfig() {
        return this.customOriginConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.originPath() == null ? 0 : this.originPath().hashCode());
        hashCode = 31 * hashCode + (this.customHeaders() == null ? 0 : this.customHeaders().hashCode());
        hashCode = 31 * hashCode + (this.s3OriginConfig() == null ? 0 : this.s3OriginConfig().hashCode());
        hashCode = 31 * hashCode + (this.customOriginConfig() == null ? 0 : this.customOriginConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.originPath() == null ^ this.originPath() == null) {
            return false;
        }
        if (other.originPath() != null && !other.originPath().equals(this.originPath())) {
            return false;
        }
        if (other.customHeaders() == null ^ this.customHeaders() == null) {
            return false;
        }
        if (other.customHeaders() != null && !other.customHeaders().equals(this.customHeaders())) {
            return false;
        }
        if (other.s3OriginConfig() == null ^ this.s3OriginConfig() == null) {
            return false;
        }
        if (other.s3OriginConfig() != null && !other.s3OriginConfig().equals(this.s3OriginConfig())) {
            return false;
        }
        if (other.customOriginConfig() == null ^ this.customOriginConfig() == null) {
            return false;
        }
        return other.customOriginConfig() == null || other.customOriginConfig().equals(this.customOriginConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.originPath() != null) {
            sb.append("OriginPath: ").append(this.originPath()).append(",");
        }
        if (this.customHeaders() != null) {
            sb.append("CustomHeaders: ").append(this.customHeaders()).append(",");
        }
        if (this.s3OriginConfig() != null) {
            sb.append("S3OriginConfig: ").append(this.s3OriginConfig()).append(",");
        }
        if (this.customOriginConfig() != null) {
            sb.append("CustomOriginConfig: ").append(this.customOriginConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String domainName;
        private String originPath;
        private CustomHeaders customHeaders;
        private S3OriginConfig s3OriginConfig;
        private CustomOriginConfig customOriginConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Origin model) {
            this.setId(model.id);
            this.setDomainName(model.domainName);
            this.setOriginPath(model.originPath);
            this.setCustomHeaders(model.customHeaders);
            this.setS3OriginConfig(model.s3OriginConfig);
            this.setCustomOriginConfig(model.customOriginConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        public final CustomHeaders getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public final Builder customHeaders(CustomHeaders customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final void setCustomHeaders(CustomHeaders customHeaders) {
            this.customHeaders = customHeaders;
        }

        public final S3OriginConfig getS3OriginConfig() {
            return this.s3OriginConfig;
        }

        @Override
        public final Builder s3OriginConfig(S3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
            return this;
        }

        public final void setS3OriginConfig(S3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
        }

        public final CustomOriginConfig getCustomOriginConfig() {
            return this.customOriginConfig;
        }

        @Override
        public final Builder customOriginConfig(CustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
            return this;
        }

        public final void setCustomOriginConfig(CustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
        }

        public Origin build() {
            return new Origin(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Origin> {
        public Builder id(String var1);

        public Builder domainName(String var1);

        public Builder originPath(String var1);

        public Builder customHeaders(CustomHeaders var1);

        public Builder s3OriginConfig(S3OriginConfig var1);

        public Builder customOriginConfig(CustomOriginConfig var1);
    }
}

