/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInvalidationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInvalidationRequest> {
    private final String distributionId;
    private final InvalidationBatch invalidationBatch;

    private CreateInvalidationRequest(BuilderImpl builder) {
        this.distributionId = builder.distributionId;
        this.invalidationBatch = builder.invalidationBatch;
    }

    public String distributionId() {
        return this.distributionId;
    }

    public InvalidationBatch invalidationBatch() {
        return this.invalidationBatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.distributionId() == null ? 0 : this.distributionId().hashCode());
        hashCode = 31 * hashCode + (this.invalidationBatch() == null ? 0 : this.invalidationBatch().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationRequest)) {
            return false;
        }
        CreateInvalidationRequest other = (CreateInvalidationRequest)((Object)obj);
        if (other.distributionId() == null ^ this.distributionId() == null) {
            return false;
        }
        if (other.distributionId() != null && !other.distributionId().equals(this.distributionId())) {
            return false;
        }
        if (other.invalidationBatch() == null ^ this.invalidationBatch() == null) {
            return false;
        }
        return other.invalidationBatch() == null || other.invalidationBatch().equals(this.invalidationBatch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.distributionId() != null) {
            sb.append("DistributionId: ").append(this.distributionId()).append(",");
        }
        if (this.invalidationBatch() != null) {
            sb.append("InvalidationBatch: ").append(this.invalidationBatch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String distributionId;
        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationRequest model) {
            this.setDistributionId(model.distributionId);
            this.setInvalidationBatch(model.invalidationBatch);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final InvalidationBatch getInvalidationBatch() {
            return this.invalidationBatch;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
        }

        public CreateInvalidationRequest build() {
            return new CreateInvalidationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInvalidationRequest> {
        public Builder distributionId(String var1);

        public Builder invalidationBatch(InvalidationBatch var1);
    }
}

